import os
import re
import sys
import time
import json
import socket
import logging
#import getpass
import subprocess
import sandbox.common.types.resource as ctr

from os.path import join as pjoin, basename, dirname

from sandbox import common

from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.process import run_process, kill_process, check_process_return_code
from sandbox.sandboxsdk.paths import make_folder, get_logs_folder, copy_path, remove_path

import sandbox.projects.samovar as samovar_resources
from sandbox.projects import resource_types
#from yt_runner import YTRunner


class SamovarTest(sdk2.Task):
    """
    Integrated Samovar test
    """
    run_ctx = {}
    tender_timelimit = 1800
    combustor_timelimit = 1800
    boiler_timelimit = 23600

    class Parameters(sdk2.Task.Parameters):
        ArcadiaRootUrl = sdk2.parameters.String("Arcadia svn url:", default=Arcadia.trunk_url(), required=True)

        CreateInstance = sdk2.parameters.Resource("Samovar create_instance tool", resource_type=samovar_resources.SAMOVAR_CREATE_INSTANCE, required=True)

        Tender = sdk2.parameters.Resource("Samovar tender tool", resource_type=samovar_resources.SAMOVAR_TENDER, required=True)

        Combustor = sdk2.parameters.Resource("Samovar combustor tool", resource_type=samovar_resources.SAMOVAR_COMBUSTOR, required=True)

        # Boiler = sdk2.parameters.Resource("Samovar boiler tool"
        #                                 ,resource_type = samovar_resources.SAMOVAR_BOILER
        #                                 ,required = False)

        ExternalData = sdk2.parameters.Resource("Samovar external data", resource_type=samovar_resources.SAMOVAR_EXTERNAL_DATA, required=False)

        InputData = sdk2.parameters.Resource("Samovar input data", resource_type=samovar_resources.SAMOVAR_INPUT_DATA, default_value=551545461, required=False)

        LocalYT = sdk2.parameters.Resource("Local YT", resource_type=resource_types.YT_LOCAL, default_value=492140132, required=False)
        RunRPCProxy = sdk2.parameters.Bool("Run RPC proxy", default=True)
        RunBoiler = sdk2.parameters.Bool("Run Boiler", default=False)

    COMMANDS = {'create_instance': '%(create_instance)s --instance-config %(instance_config)s --force', 'create_instance_uzor': '%(create_instance)s --uzor-config %(uzor_config)s --mode uzor', 'tender': ('%(tender)s --instance-config %(instance_config)s --config %(tender_config)s'
                               ' --triggers %(triggers_config)s --port %(tender_port)s --from-files %(input_data)s')              # ,'combustor' : ('%(combustor)s --instance-config %(instance_config)s --config %(combustor_config)s --port %(combustor_port)s --url-agents 1')
               , 'combustor': ('%(combustor)s --instance-config %(instance_config)s --config %(combustor_config)s --port %(combustor_port)s --url-agents 1 --host-agents 1'), 'boiler': ('%(boiler)s --instance-config %(instance_config)s --config %(boiler_config)s --port %(boiler_port)s'), 'delete_instance': '%(create_instance)s --instance-config %(instance_config)s --just-drop'}

    CHECK_TABLES_ON_STAGES = {"tender1": ["url_push", "host_push"], "combustor1": ["url_push", "url_data", "host_data"], "boiler1": ["host_push"], "tender2": ["url_push", "host_push"], "combustor2": ["url_push", "url_data", "host_data"], "boiler2": ["host_push"]}

    # TODO remove it and make map node identifying
    INSTANCE_DIRS = ["duplicates",
                     "export",
                     "factor_dump",
                     "global_combine_tmp",
                     "globalhisto",
                     "imports",
                     "lemur_url_data",
                     "push_monster_hosts",
                     "static_pushes",
                     "uzor"]

    def _get_run_ctx(self):
        resources = {'create_instance': self.Parameters.CreateInstance, 'tender': self.Parameters.Tender, 'combustor': self.Parameters.Combustor                    # 'boiler': self.Parameters.Boiler
                    , 'external_data': self.Parameters.ExternalData, 'input_data': self.Parameters.InputData, 'local_yt_res': self.Parameters.LocalYT
                    }

        if not self.Parameters.ExternalData:
            self.Parameters.ExternalData = list(sdk2.Resource.find(
                resource_type=samovar_resources.SAMOVAR_EXTERNAL_DATA,
                state=ctr.State.READY,
            ).limit(1))[0]

        for i, k in resources.iteritems():
            self.run_ctx[i] = str(sdk2.ResourceData(k).path)

        copy_path(dirname(self.run_ctx['external_data']), self.run_dir)
        self.run_ctx['external_data'] = pjoin(self.run_dir, basename(self.run_ctx['external_data']))

        cmd = ["tar", "-xf", self.run_ctx['local_yt_res'], "-C", self.yt_resource_dir]
        run_process(cmd)
        self.yt_wrapper = pjoin(self.yt_resource_dir, "bin", "yt_local")
        self.yt_bin = pjoin(self.yt_resource_dir, "bin", "yt2")

        self.run_ctx['instance_config'] = pjoin(self.samovar_conf_dir, 'instance_config.pb.txt')
        self.run_ctx['uzor_config'] = pjoin(self.uzor_conf_dir, 'uzorconfig.pb.txt')
        self.run_ctx['triggers_config'] = pjoin(self.run_ctx['external_data'], 'triggers_kiwi.pb.txt')

        for t in ['create_instance', 'create_instance_uzor', 'delete_instance']:
            self.run_ctx[t+'_stdout'] = pjoin(self.log_dir, t+'.out')
            self.run_ctx[t+'_stderr'] = pjoin(self.log_dir, t+'.err')

        for t in ['tender', 'combustor', 'boiler']:
            self.run_ctx[t+'_port'] = self._get_free_port()
            self.run_ctx[t+'_output'] = pjoin(self.log_dir, t+'.log')
            self.run_ctx[t+'_stdout'] = pjoin(self.log_dir, t+'.out')
            self.run_ctx[t+'_stderr'] = pjoin(self.log_dir, t+'.err')
            self.run_ctx[t+'_config'] = pjoin(self.samovar_conf_dir, t+'_config.pb.txt')
            self.run_ctx[t+'_pid_file'] = pjoin(self.log_dir, t+'.pid')

    def _parse_arcadia_url(self):
        url_split = self.Parameters.ArcadiaRootUrl.split('@')
        revision = None
        arcadia_url = self.Parameters.ArcadiaRootUrl

        if len(url_split) > 1:
            arcadia_url = url_split[0]
            revision = url_split[1]

        return arcadia_url, revision

    def _get_free_port(self):
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind(('', 0))
        port = s.getsockname()[1]
        s.close()
        return port

    def _run_tool(self, tool, wait=False, check=False, stage=1):
        logging.debug("Starting {}...".format(tool))
        check_wait_time = 30
        restart_run_times = 10
        process = None
        cmd = self.COMMANDS[tool] % self.run_ctx
        logging.debug("CMD: {}".format(''.join(cmd)))
        env = {"YT_USER": self.username,
               "YT_TOKEN": self.yt_token
              }

        if wait:
            stdout_file = self.run_ctx[tool+'_stdout']+str(stage)
            stderr_file = self.run_ctx[tool+'_stderr']+str(stage)
            stdout = open(stdout_file, 'w')
            stderr = open(stderr_file, 'w')
            try:
                process = run_process(cmd, wait=wait, check=check, stdout=stdout, stderr=stderr, environment=env)
            finally:
                stdout.close()
                stderr.close()
        else:
            n = 1
            while n <= restart_run_times:
                stdout_file = self.run_ctx[tool+'_stdout']+str(stage)+"-"+str(n)
                stderr_file = self.run_ctx[tool+'_stderr']+str(stage)+"-"+str(n)
                stdout = open(stdout_file, 'w')
                stderr = open(stderr_file, 'w')

                process = run_process(cmd, wait=wait, check=check, stdout=stdout, stderr=stderr, environment=env)
                time.sleep(check_wait_time)
                if process.poll() is None:
                    logging.debug("Tool '{}' is running.".format(tool))
                    stdout.close()
                    stderr.close()
                    break
                elif not(process.poll() is None) and  process.returncode != 0:
                    logging.debug("Tool '{}' failed with error file: '{}'".format(tool, stderr_file))
                stdout.close()
                stderr.close()
                n += 1

            if n > restart_run_times:
                raise Exception("Exceeded max restart limit: {} for '{}'".format(restart_run_times, tool))

        return process

    def _get_tender_push_counter(self, counter):
        p = subprocess.Popen("curl -v localhost:%(tender_port)s/counters" % self.run_ctx, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)

        stdout, stderr = p.communicate()
        m = re.search('{}\s*:\s*([0-9]+)'.format(counter), stdout)
        if m:
            pcount = m.group(1)
            return pcount

        return 0

    def _get_combustor_counters(self):
        p = subprocess.Popen("curl -v localhost:%(combustor_port)s/counters" % self.run_ctx, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)

        stdout, stderr = p.communicate()
        m = re.search('.+<pre>(.+)</pre>', stdout)
        if m:
            counters = m.group(1)
            return json.loads(counters)

        return None

    def _save_table(self, table, file_name):
        sys.path.insert(0, pjoin(self.yt_resource_dir, 'python'))
        from yt.wrapper import YtClient
        import yt.wrapper
        yt_client = YtClient(proxy=self.yt_proxy, config={'api_version': 'v3'}, token=self.yt_token)
        resp = None
        try:
            logging.debug("Save table: {}".format(self.tables[table]))
            resp = list(yt_client.select_rows(
                "* from [{}]".format(self.tables[table]),
                format=yt.wrapper.JsonFormat(),
                raw=False
            ))
        except Exception:
            pass

        if resp is None:
            raise Exception("Undefined YT response")

        with open(pjoin(self.out_dir, "{}.json".format(file_name)), 'w') as f:
            for l in resp:
                f.write("{}\n".format(str(l)))

    def _save_tables(self, prefix):
        for t in self.CHECK_TABLES_ON_STAGES[prefix]:
            self._save_table(t, "{}_{}".format(t, prefix))

    def _save_counters(self, tool, postfix):
        curl_cmd = "curl -v localhost:%({}_port)s/counters".format(tool)

        p = subprocess.Popen(curl_cmd % self.run_ctx, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)

        stdout, stderr = p.communicate()

        lines = stdout.split("\n")
        catch = False
        counters = []
        for l in lines:
            if "<pre>" in l:
                catch = True
            if "</pre>" in l:
                break

            if catch:
                counters.append(l.replace('<pre>', ''))

        if counters:
            file_name = "{}.{}.txt".format(tool, postfix)
            with open(pjoin(self.out_dir, file_name), 'w') as f:
                for c in counters:
                    f.write("{}\n".format(c))

        return counters

    def _get_table_row_count(self, table):
        sys.path.insert(0, pjoin(self.yt_resource_dir, 'python'))
        from yt.wrapper import YtClient
        import yt.wrapper
        yt_client = YtClient(proxy=self.yt_proxy, config={'api_version': 'v3'}, token=self.yt_token)
        resp = None

        try:
            resp = list(yt_client.select_rows(
                "sum(1) as count from [{}] group by 0".format(table),
                format=yt.wrapper.JsonFormat(),
                raw=False
            #    input_row_limit=10000000,
            ))
        except Exception:
            # TODO: catch yt-specific exception
            raise Exception

        if not resp:
            return 0

        return resp[0]['count']

    def _get_table_attribute(self, table, attr):
        sys.path.insert(0, pjoin(self.yt_resource_dir, 'python'))
        from yt.wrapper import YtClient
        yt_client = YtClient(proxy=self.yt_proxy, config={'api_version': 'v3'}, token=self.yt_token)
        value = None
        try:
            value = yt_client.get_attribute(self.tables[table], attr)
        except Exception:
            # TODO: catch yt-specific exception
            pass

        return value

    def _get_instance_state(self):
        instance_state = {"row_count": {}}
        for i, v in self.tables.iteritems():
            instance_state['row_count'][i] = int(self._get_table_row_count(v))

        logging.debug("Instance state '{}':\n{}\n".format(self.bprefix, json.dumps(instance_state, indent=3)))

        return instance_state

    def _wait_tender_stage(self, process):
        cur_time = 0
        sleep_time = 30

        cur_tender_host_pushes = None
        cur_tender_url_pushes = None
        prev_tender_host_pushes = None
        prev_tender_url_pushes = None

        while cur_time <= self.tender_timelimit and process.returncode is None:
            process.poll()
            check_process_return_code(process)

            if not process.returncode is None:
                raise Exception("Tender has terninated on one's own")

            prev_state = self._get_instance_state()
            logging.debug("Previous state:\n{}\n".format(json.dumps(prev_state, indent=3)))

            prev_tender_url_pushes = int(self._get_tender_push_counter('UrlPushesTotal'))
            prev_tender_host_pushes = int(self._get_tender_push_counter('HostPushesTotal'))

            time.sleep(sleep_time)
            cur_time += sleep_time

            cur_state = self._get_instance_state()

            logging.debug("Current state:\n{}\n".format(json.dumps(cur_state, indent=3)))
            cur_tender_url_pushes = int(self._get_tender_push_counter('UrlPushesTotal'))
            cur_tender_host_pushes = int(self._get_tender_push_counter('HostPushesTotal'))
            logging.debug("prev_tender_url_pushes: {}".format(prev_tender_url_pushes))
            logging.debug("cur_tender_url_pushes: {}".format(cur_tender_url_pushes))
            logging.debug("prev_tender_host_pushes: {}".format(prev_tender_host_pushes))
            logging.debug("cur_tender_host_pushes: {}".format(cur_tender_host_pushes))
            logging.debug("Current state:\n{}\n".format(json.dumps(cur_state, indent=3)))

#               cur_tender_url_pushes   == cur_state['row_count']['url_push']  and\ #
#               cur_tender_host_pushes  == cur_state['row_count']['host_push'] and\ #

            if prev_tender_url_pushes == cur_tender_url_pushes  and\
               prev_tender_host_pushes == cur_tender_host_pushes and\
               cur_state['row_count']['url_push'] != 0 and \
               cur_state['row_count']['host_push'] != 0:
                logging.debug("Tender stage finished!")
                break

        if cur_time > self.tender_timelimit:
            raise Exception("Tender exceeded time limit: {}".format(self.tender_timelimit))

    def _wait_combustor_stage(self, process):
        cur_time = 0
        sleep_time = 30

        while cur_time <= self.combustor_timelimit and process.returncode is None:
            process.poll()
            check_process_return_code(process)

            if not process.returncode is None:
                raise Exception("Combustor has terninated on one's own")

            combustor_counters = self._get_combustor_counters()
            logging.debug("COMBUSTOR COUNTERS:\n{}\n".format(json.dumps(combustor_counters, indent=3)))

            prev_state = self._get_instance_state()
            logging.debug("PREVIOUS STATE:\n{}\n".format(json.dumps(prev_state, indent=3)))

            time.sleep(sleep_time)
            cur_time += sleep_time

            cur_state = self._get_instance_state()
            logging.debug("CURRENT STATE:\n{}\n".format(json.dumps(cur_state, indent=3)))

            if cur_state['row_count']['url_push'] == 0 and \
                cur_state['row_count']['host_push'] == 0 and \
                cur_state['row_count']['url_data'] != 0 and \
                cur_state['row_count']['host_data'] != 0 and \
                prev_state['row_count']['url_data'] == cur_state['row_count']['url_data'] and\
                prev_state['row_count']['host_data'] == cur_state['row_count']['host_data']:
                logging.debug("Combustor Finished!")
                break

        if cur_time > self.combustor_timelimit:
            raise Exception("Combustor exceeded time limit: {}".format(self.combustor_timelimit))

    def _wait_boiler_stage(self, process):
        cur_time = 0
        sleep_time = 30

        while cur_time <= self.boiler_timelimit and process.returncode is None:
            process.poll()
            check_process_return_code(process)

            if not process.returncode is None:
                raise Exception("Boiler has terninated on one's own")

            prev_state = self._get_instance_state()
            logging.debug("Previous state:\n{}\n".format(json.dumps(prev_state, indent=3)))

            time.sleep(sleep_time)
            cur_time += sleep_time

            cur_state = self._get_instance_state()
            logging.debug("Current state:\n{}\n".format(json.dumps(cur_state, indent=3)))

            if prev_state['row_count']['host_push'] == cur_state['row_count']['host_push']:
                logging.debug("Boiler Finished!")
                break

        if cur_time > self.boiler_timelimit:
            raise Exception("Boiler exceeded time limit: {}".format(self.boiler_timelimit))

    def _prepare_configs_local(self):
        files = [pjoin(self.samovar_conf_dir, 'instance_config.pb.txt'),
          pjoin(self.samovar_conf_base_dir, 'conf-production', 'instance_config_rpc_proxy.pb.txt'),
          pjoin(self.samovar_conf_base_dir, 'conf-production', 'instance_config_native.pb.txt'),
          pjoin(self.samovar_conf_base_dir, 'conf-common', 'duplicates_config.pb.txt')
        ]

        catch = False
        for config in files:
            new_config = []
            with open(config) as f:
                for l in f:
                    m = re.search(r'\s*BasePrefix\s*:\s*\"(\S+)\"', l)
                    if m:
                        if not catch:
                            bprefix = m.group(1)
                            bprefix = bprefix.replace('%username%', self.username)
                            self.bprefix = bprefix
                            catch = True
                            l = "BasePrefix: \"{}\"\n".format(self.bprefix)

                    m = re.search(r'\s*Server:\s*\"\s*(\S+)\s*"', l)
                    if m:
                        l = "Server: \"{}\"\n".format(self.yt_proxy)

                    if "RpcProxyAddresses" not in l:
                        new_config.append(l)

                if hasattr(self, 'rpc_proxy'):
                    new_config.append("RpcProxyAddresses: \"{}\"".format(self.rpc_proxy))

            with open(config, 'w') as f:
                for l in new_config:
                    f.write(l)

    def _prepare_uzor_config_local(self):
        new_uzor_config = []
        uzor_config_file = pjoin(self.uzor_conf_dir, 'uzorconfig.pb.txt')
        with open(uzor_config_file) as f:
            catch = False
            for l in f:
                m = re.search(r'\s*YtInstanceConfig\s*{', l)
                if m:
                    catch = True
                m = re.search(r'(\s*Server\s*:\s*\").+(\")', l)
                if catch and m:
                    l = m.group(1)+self.yt_proxy+m.group(2)+'\n'
                    l += "    User: \"root\"\n"

                    if hasattr(self, 'rpc_proxy'):
                        l += "    RpcProxyAddresses: \""+self.rpc_proxy+"\"\n"
                    new_uzor_config.append(l)

                if "RpcProxyAddresses" not in l:
                    new_uzor_config.append(l)

        with open(uzor_config_file, 'w') as f:
            for l in new_uzor_config:
                f.write(l)

    def _prepare_configs_remote(self):
        files = [pjoin(self.samovar_conf_dir, 'instance_config.pb.txt')]
        catch = False
        for config in files:
            new_config = []
            with open(config) as f:
                for l in f:
                    m = re.search(r'\s*BasePrefix\s*:\s*\"(\S+)\"', l)
                    if m:
                        if not catch:
                            catch = True
                            self.bprefix = "//home/samovar-dev/samovar_{}/{}".format(self.username, self.id)
                            #self.bprefix = "//home/samovar-dev/samovar_{}".format(self.username)
                            l = "BasePrefix: \"{}\"\n".format(self.bprefix)
                    new_config.append(l)

            with open(config, 'w') as f:
                for l in new_config:
                    f.write(l)

    def _prepare_uzor_config_remote(self):
        files = [pjoin(self.uzor_conf_dir, 'uzorconfig.pb.txt'),
                 pjoin(self.samovar_conf_base_dir, 'conf-devel', 'uzorclient_config.pb.txt')]

        for config in files:
            new_config = []

            with open(config) as f:
                catch = False
                for l in f:
                    m = re.search(r'\s*YtInstanceConfig\s*{', l)
                    if m:
                        catch = True

                    m = re.search(r'\s*BasePrefix\s*:\s*\"(\S+)\"', l)
                    if (catch and m and (config == files[0])) or m:
                        l = "BasePrefix: \"{}/uzor\"\n".format(self.bprefix)

                    new_config.append(l)

            with open(config, 'w') as f:
                for l in new_config:
                    f.write(l)

    def _prepare_configs(self):
        self._prepare_configs_remote()

    def _prepare_uzor_config(self):
        self._prepare_uzor_config_remote()

    def _pre_setup(self):
        self.work_dir = os.getcwd()
        self.samovar_dir = pjoin(self.work_dir, "samovar")
        self.uzor_dir = pjoin(self.work_dir, "uzor")
        self.samovar_conf_base_dir = pjoin(self.samovar_dir, "conf")
        self.samovar_conf_dir = pjoin(self.samovar_conf_base_dir, "conf-devel")
        self.uzor_conf_dir = pjoin(self.uzor_dir, "conf", "conf-samovar-local")
        self.run_dir = pjoin(self.samovar_dir, 'run')
        self.yt_resource_dir = pjoin(self.work_dir, 'yt_client')
        self.out_dir = pjoin(self.work_dir, 'out')
        self.username = "zomb-samovar-tester"  # getpass.getuser()

        make_folder(self.yt_resource_dir)
        make_folder(self.out_dir)

        self.log_dir = get_logs_folder()
        os.environ["TEST_TIME"] = "1518767779"
        #os.environ["TEST_RANDOM"] = "1"
        #os.environ["STATIC_DISTRIBUTED_HISTOGRAMS"] = "1"

    def compress_out_data(self):
        os.chdir(self.out_dir)
        for f in os.listdir(self.out_dir):
            cmd = ['tar', 'czf', f+'.tgz', f]
            process = run_process(cmd)
            check_process_return_code(process)
            remove_path(f)

    def _get_instance_tables(self):
        sys.path.insert(0, pjoin(self.yt_resource_dir, 'python'))
        from yt.wrapper import YtClient
        yt_client = YtClient(proxy=self.yt_proxy, config={'api_version': 'v3'}, token=self.yt_token)

        logging.debug("BASE_PREFIX: "+self.bprefix)
        self.tables = {}
        all_tables = yt_client.list(self.bprefix, absolute=True)
        logging.debug("PROXY: {}".format(self.yt_proxy))
        logging.debug("INSTANCE_TABLES in {}:".format(self.bprefix))
        for t in all_tables:
            if "tmp" not in t and basename(t) not in self.INSTANCE_DIRS:  # TODO check for t is table or node
                self.tables[basename(t)] = t
                logging.debug("{} : {}".format(basename(t), t))

    def on_execute(self):

        self._pre_setup()
        arcadia_url, revision = self._parse_arcadia_url()
        CHECKOUTS = {'robot/samovar': self.samovar_dir, 'robot/uzor': self.uzor_dir}

        for k, v in CHECKOUTS.iteritems():
            self.run_ctx['arcadia_path'] = Arcadia.checkout(pjoin(arcadia_url, k), v, revision=revision)

        self._get_run_ctx()
        logging.debug("RUN_CTX: {}".format(json.dumps(self.run_ctx, indent=3)))

        #self.yt_runner = YTRunner(self.yt_wrapper, self.yt_bin, self.log_dir)
        # os.chdir(self.yt_resource_dir)
        # self.yt_runner.start(self.Parameters.RunRPCProxy)
        # self.yt_runner.create_user(self.username)
        #self.yt_runner.set_acl("//home", "[{action=allow;permissions=[read;write;mount;remove];subjects=["+self.username+"]}]")

        # self.yt_runner.create_user('alexvin')
        #self.yt_runner.set_acl("//home", "[{action=allow;permissions=[read;write;mount;remove];subjects=[alexvin]}]")

        # if (self.Parameters.RunRPCProxy):
        #    self.rpc_proxy = self.yt_runner.get_rpc_proxy()
        #    logging.debug("RPC PROXY: {}".format(str(self.rpc_proxy)))

        #self.yt_proxy = "{}:{}".format(socket.gethostname(), self.yt_runner.get_port())
        try:
            self.yt_token = sdk2.Vault.data("zomb-samovar-tester-yt-token")
        except common.errors.VaultError:
            raise common.errors.TaskFailure("Error during vault data extracting")

        logging.debug("VAULT DATA: {}".format(self.yt_token))
        self.yt_proxy = "freud.yt.yandex.net"
        self._prepare_configs()
        self._prepare_uzor_config()

        logging.debug("YT proxy: {}".format(self.yt_proxy))
        time.sleep(5)

        try:
            # run create_instance
            os.chdir(self.samovar_dir)
            self._run_tool('create_instance', wait=True, check=True)

            # self.yt_runner.list(self.bprefix)
            self._run_tool('create_instance_uzor', wait=True, check=True)
            self._get_instance_tables()
           # self.yt_runner.list(self.bprefix)

            # run tender 1
            tender_process = self._run_tool('tender', stage=1)
            self._wait_tender_stage(tender_process)
            self._save_counters("tender", "1")
            kill_process(tender_process.pid)

            # self.yt_runner.list(self.bprefix)
            # logging.debug("SLEEPING...")
            # time.sleep(7200)

            logging.debug("Changing dir to :{}".format(self.samovar_dir))
            os.chdir(self.samovar_dir)

            # run combustor 1
            combustor_process = self._run_tool('combustor', stage=1)
            self._wait_combustor_stage(combustor_process)
            # self._save_tables("combustor1")
            self._save_counters("combustor", "1")
            kill_process(combustor_process.pid)
            # logging.debug("SLEEPING...")
            # time.sleep(7200)
            # run boiler 1
            if self.Parameters.RunBoiler:
                boiler_process = self._run_tool('boiler', stage=1)
                self._wait_boiler_stage(boiler_process)
                kill_process(boiler_process.pid)
                self._save_tables("boiler1")

            # run tender 2
            tender_process = self._run_tool('tender', stage=2)
            self._wait_tender_stage(tender_process)

            # self._save_tables("tender2")
            self._save_counters("tender", "2")
            kill_process(tender_process.pid)

            logging.debug("Changing dir to :{}".format(self.samovar_dir))
            os.chdir(self.samovar_dir)

            # run combustor 2
            combustor_process = self._run_tool('combustor', stage=2)
            self._wait_combustor_stage(combustor_process)

            # self._save_tables("combustor2")
            self._save_counters("combustor", "2")
            kill_process(combustor_process.pid)

            # run boiler 2
            if self.Parameters.RunBoiler:
                boiler_process = self._run_tool('boiler', stage=2)
                self._wait_boiler_stage(boiler_process)
                kill_process(boiler_process.pid)
                self._save_tables("boiler2")

            self.compress_out_data()
            logging.debug("out dir: {}".format(self.out_dir))

            resData = sdk2.ResourceData(samovar_resources.SAMOVAR_TEST_OUT(self, "{} Task:#{} Revision:{}".format(self.type, self.id, revision), path=self.out_dir, ttl=30
                                                      )
                                       )
            resData.ready()

        finally:
            # delete instance
            self._run_tool('delete_instance', wait=True, check=True)
            # terminate YT
            # os.chdir(self.yt_resource_dir)
            # self.yt_runner.stop()
            # self.yt_runner.delete()
            logging.debug("Task finished")
