# coding: utf-8

from sandbox.sdk2.resource import AbstractResource
from sandbox.projects import resource_types
from sandbox.projects.resource_types import releasers as resource_releasers

quality_releasers = resource_releasers.samovar_releasers + ['andreytert', 'zenoyan', 'pet67', 'socialgraph', 'alex-mourne', 'nsa6', 'aasleptsov', 'edik']

# base classes
class SAMOVAR_SYMBOLS_ARCHIVE(AbstractResource):
    """
        Symbols from samovar binaries
    """
    releasable = True
    executable = False
    any_arch = False
    releasers = resource_releasers.samovar_releasers


class SAMOVAR_BINARY(AbstractResource):
    """
        Base class for binary files used in Samovar Project.
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = resource_releasers.samovar_releasers


# samovar
class SAMOVAR_COMBUSTOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/combustor/server/combustor'


class SAMOVAR_TENDER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tender/server/tender'


class SAMOVAR_LB_WRITER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/lb_writer/server/lb_writer'


class SAMOVAR_BOILER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/boiler/server/boiler'
    always_strip = True


class SAMOVAR_GAGEBOARD(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/gageboard/server/gageboard'


class SAMOVAR_INDEX_NOW_SERVER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/index_now/http_server/server'


class SAMOVAR_INDEX_NOW_REQUEST_PROCESSOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/index_now/request_processor/request_processor'


class SAMOVAR_HITRENIMALS_PP(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/zora/tools/hitrenimals_pp/main/hitrenimals_pp'


class SAMOVAR_CM_FILTER_BUILD(SAMOVAR_BINARY):
    arcadia_build_path = 'yweb/robot/tools/filter_build/filter_build'


class SAMOVAR_GLOBAL_COUNTERS_TOOL(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/global_counters_tool/global_counters_tool'


class SAMOVAR_CREATE_INSTANCE(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/create_instance/create_instance'


class SAMOVAR_SALMON_AGENT(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/monitoring/salmon_agent/salmon_agent'


class SAMOVAR_SVN_CONFIGS(AbstractResource):
    """
        Class for Samovar configs from svn
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


class SAMOVAR_SVN_SCRIPTS(SAMOVAR_SVN_CONFIGS):
    """
        Class for Samovar scripts from svn
    """
    pass


class SAMOVAR_GAGEBOARD_FRONTEND(SAMOVAR_SVN_CONFIGS):
    """
        Class for Samovar Gageboard frontend files from svn
    """
    pass


class SAMOVAR_EXTERNAL_DATA(SAMOVAR_SVN_CONFIGS):
    """
        Class for Samovar external data
    """
    releasers = ['abogutskiy', 'gous32', 'robot-samovar', 'zosimov']


class SAMOVAR_INPUT_DATA(AbstractResource):
    """
        Class for Samovar input data
    """
    uploadable = True
    any_arch = True


class SAMOVAR_UZOR_BIN(SAMOVAR_BINARY):
    pass


class SAMOVAR_UZOR_SVN_CONFIGS(SAMOVAR_SVN_CONFIGS):
    pass


class SAMOVAR_TEST_OUT(AbstractResource):
    """
        Samovar YT tables after test run
    """

class SAMOVAR_EJECTOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/ejector/server/ejector'


class SAMOVAR_TRANSFER_FACTOR_DUMP_TOOL(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/features/transfer_factor_dump/transfer_factor_dump'


class SAMOVAR_MERGE_FACTOR_DUMP_DELTAS_TOOL(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/features/merge_factor_dump_deltas/merge_factor_dump_deltas'


class SAMOVAR_PUSH_MONSTER_HOSTS_MERGER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/push_monster_hosts_merger/push_monster_hosts_merger'


class SAMOVAR_RENEWED(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/renewed/renewed'


class SAMOVAR_PUSH_WRITER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/push_writer/push_writer'


class SAMOVAR_HOST_REMOVER(SAMOVAR_BINARY):  # obsolete
    arcadia_build_path = 'robot/samovar/tools/host_remover/host_remover'


class SAMOVAR_RECORD_REMOVER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/record_remover/record_remover'


class SAMOVAR_GEN_OWNER2HOST_MAP(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/gen_owner2host_map/gen_owner2host_map'


class SAMOVAR_LOG2YT(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/log2yt/log2yt'


class SAMOVAR_COUNTERS_TOOL(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/lemur/tools/counters_tool/counters_tool'


class SAMOVAR_SNIPPETS_MERGER_NEW(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/snippets_merger_new/snippets_merger_new'


class SAMOVAR_EXPORT_PROCESSOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/export_processor/export_processor'


class SAMOVAR_EXPORT_PRIMARY_HOST_DATA(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/export_primary_host_data/export_primary_host_data'


class SAMOVAR_EXPORT_LB_WRITER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/export_lb_writer/export_lb_writer'


class SAMOVAR_PREPARE_WATCH_LOG_WHITE_COUNTERS(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/prepare_watch_log_white_counters/prepare_watch_log_white_counters'


class SAMOVAR_YT_LEVELER(SAMOVAR_BINARY): # obsolete
    arcadia_build_path = 'robot/samovar/tools/yt_leveler/yt_leveler'


class SAMOVAR_LIMITS_TESTER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/limits_tester/limits_tester'


class SAMOVAR_URL_REDUCE_DURATION_CALC(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/url_reduce_duration_calc/url_reduce_duration_calc'


class SAMOVAR_DIRECT_DATA(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/direct_data/direct_data'


class SAMOVAR_UZOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/uzor/bin/uzor'


class SAMOVAR_SVN_MODELS(AbstractResource):
    """
        Class for Samovar models
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


class SAMOVAR_TOPS_MONITOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/tops_monitor/tops_monitor'


class SAMOVAR_QUEUE_ANALYZER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/queue_analyzer/queue_analyzer'


class SAMOVAR_TABLETS_MONITOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/tablets_monitor/tablets_monitor'


class SAMOVAR_ZORACL(SAMOVAR_BINARY):
    arcadia_build_path = 'zora/client/main/zoracl'


class SAMOVAR_QUEUE_PROCESSOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/queue_processor/queue_processor'


class SAMOVAR_MOBILE_DETECTOR_MERGER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/mobile_detector/merger/mobile_detector_merger'


class SAMOVAR_MOBILE_DETECTOR_JOINER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/mobile_detector/joiner/mobile_detector_joiner'


class SAMOVAR_MOBILE_DETECTOR_COUNTER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/mobile_detector/counter/mobile_detector_counter'


class SAMOVAR_ZLOG_PROCESSOR(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/tools/zlog_processor/zlog_processor'


# Limbo
class SAMOVAR_CONSUMER_TABLES_MERGER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/consumer_tables_merger/consumer_tables_merger'


class SAMOVAR_WIKIMEDIA_UPDATES_READER(SAMOVAR_BINARY):
    arcadia_build_path = 'robot/samovar/tools/wikimedia_updates_reader/wikimedia_updates_reader'


# Quality
class QUALITY_BINARY(SAMOVAR_BINARY):
    releasers = quality_releasers

class SAMOVAR_COMPLIANCE_CHECKER(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/compliance_checker/compliance_checker'


class SAMOVAR_COMPLIANCE_TOOL(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/compliance_tool/compliance_tool'


class SAMOVAR_FEED_DUMP_CUTTER(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/feed_dump_cutter/feed_dump_cutter'


class SAMOVAR_TABLE_BALANCER(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/table_balancer/table_balancer'


class SAMOVAR_FEATURES_PRODUCE_SHOWS(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/features/produce_shows/produce_shows'


class SAMOVAR_FEATURES_PRODUCE_CRAWLS(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/features/produce_crawl_logs/produce_crawl_logs'


class SAMOVAR_TABLE_SAMPLER(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/table_sampler/table_sampler'


class SAMOVAR_CRAWL_STAT(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/crawl_stat/crawl_stat'


class SAMOVAR_SMALL_URL_DATA_TABLE_MERGER(QUALITY_BINARY):
    arcadia_build_path = 'robot/samovar/tools/small_url_data_table_merger/small_url_data_table_merger'


class SAMOVAR_MERGE_SAMOVAR_SENDLINK_DUMP_DELTAS(QUALITY_BINARY):
    arcadia_build_path = 'robot/lemur/tools/merge_samovar_sendlink_dump_deltas/merge_samovar_sendlink_dump_deltas'


class SAMOVAR_MERGE_SAMOVAR_DUMPS_DELTAS_TO_DAILY(QUALITY_BINARY):
    arcadia_build_path = 'robot/lemur/tools/merge_samovar_dumps_deltas_to_daily/merge_samovar_dumps_deltas_to_daily'


class SAMOVAR_ROTOR_RANK_COLLECT_HOST_COUNTERS(QUALITY_BINARY):
    arcadia_build_path = 'robot/quality/rotor_rank/collect_host_counters/rr_collect_host_counters'


class SAMOVAR_USERDATA_FACTORS(QUALITY_BINARY):
    arcadia_build_path = 'robot/quality/userdata_factors/userdata_factors'


class SAMOVAR_QUALITY_FULL_EDR(QUALITY_BINARY):
     arcadia_build_path = 'robot/quality/full_edr/full_edr'


class SAMOVAR_HOSTDATA_EXPORT(QUALITY_BINARY):
    arcadia_build_path = 'robot/quality/dns_spam_detector/hostdata_export/hostdata_export'


class SAMOVAR_COMPLIANCE_SAMPLES(AbstractResource):
    """
        Class for Compliance Samples
    """
    releasable = True
    executable = False
    releasers = quality_releasers


class SAMOVAR_QUALITY_SVN_SCRIPTS(SAMOVAR_SVN_CONFIGS):
    """
        Class for quality scripts
    """
    releasers = quality_releasers
