import sys
import json
import logging
import argparse

import six
if six.PY2:
    import collector
else:
    from . import collector


def parse_args():
    parser = argparse.ArgumentParser(
        formatter_class=lambda *args, **kwargs: argparse.ArgumentDefaultsHelpFormatter(*args, width=120, **kwargs),
        description="Sandbox tasks code postprocessing"
    )
    parser.add_argument("-o", "--out", default=None, help="Dump JSON data to file (default: stdout)")
    parser.add_argument("-e", "--err", default=None, help="Save error messages to file (default: stderr)")
    parser.add_argument("-g", "--groups", required=True, help="Path to directory with Arcadia groups")
    parser.add_argument("-p", "--projects", default=None, help="Task projects dir based on fake arc root")
    parser.add_argument(
        "-t", "--tasks", default=None, help=(
            "Path to directory with \"projects\". "
            "If omitted, assume tasks code is already importable (sys.path / PYTHONPATH tweaks)"
        )
    )
    return parser.parse_args()


def main():
    options = parse_args()

    errfile = sys.stderr if options.err is None else open(options.err, "w")
    logger = logging.getLogger("tasks_code_parser")
    logger.addHandler(logging.StreamHandler(errfile))
    metadata = collector.parse_tasks_code(options.groups, options.tasks, logger, options.projects)

    outfile = sys.stdout if options.out is None else open(options.out, "w")
    outfile.write(json.dumps(metadata, ensure_ascii=False).encode("utf-8"))


if __name__ == "__main__":
    main()
