# coding: utf-8
from __future__ import unicode_literals

import os
import tarfile
import six
if six.PY2:
    import subprocess32 as sp
else:
    import subprocess as sp

from sandbox import sdk2

from sandbox.projects.sandbox import resources
from sandbox.projects.common.arcadia import sdk as arcadia_sdk


class BuildSandboxTutorial(sdk2.Task):

    class Requirements(sdk2.Requirements):
        disk_space = 3 * 1024

    class Parameters(sdk2.Parameters):
        description = "Build sandbox/docs"
        kill_timeout = 600
        notifications = []

        url = sdk2.parameters.String("Arcadia URL", default="arcadia-arc:/#trunk")

    def on_execute(self):

        with arcadia_sdk.mount_arc_path(self.Parameters.url, fallback=True) as path:

            # Build docs
            ya_path = os.path.join(path, "ya")
            target = os.path.join(path, "sandbox/docs")
            with sdk2.helpers.ProcessLog(self, logger="ya_make") as pl:
                sp.check_call([ya_path, "make", target], stdout=pl.stdout, stderr=pl.stderr)

            docs_archive = os.path.join(target, "docs.tar.gz")
            with tarfile.open(docs_archive) as f:
                f.extractall(str(self.path("docs")))

            package = resources.SandboxDocsAssets(
                task=self,
                description="sandbox/docs",
                path="./docs"
            )
            resource_data = sdk2.ResourceData(package)
            resource_data.ready()
