from __future__ import absolute_import

import logging

import sandbox.common.types.task as ctt
import sandbox.common.types.client as ctc

from sandbox import sdk2
from sandbox.projects.sandbox import cleanup_2


class CleanupRunner(sdk2.Task):

    class Requirements(sdk2.Requirements):
        client_tags = ctc.Tag.LXC | ctc.Tag.PORTOD
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        client_tags = sdk2.parameters.ClientTags("Client tags", required=True)
        with sdk2.parameters.String("Subtasks priority") as subtasks_priority:
            p = ctt.Priority()
            # noinspection PyTypeChecker
            subtasks_priority.values[str(int(p))] = subtasks_priority.Value(str(p), default=True)
            while p != p.next:
                p = p.next
                # noinspection PyTypeChecker
                subtasks_priority.values[str(int(p))] = str(p)
        subtasks_kill_timeout = sdk2.parameters.Integer("Subtasks kill timeout", default=10 * 60 * 60)

    def on_execute(self):
        total = self.server.client.read(tags=str(self.Parameters.client_tags), limit=0)["total"]
        clients = self.server.client.read(tags=str(self.Parameters.client_tags), limit=total)["items"]
        for client in clients:
            host = client["id"]
            logging.info("Create task for host %s", host)
            prev_cleanup = sdk2.Task.find(
                type=cleanup_2.Cleanup2.type, tags=host, status=ctt.TaskStatus.ENQUEUED, children=True,
            ).first()
            if prev_cleanup:
                logging.info("Skip cleanup for %s since previous task %s is still enqueued", host, prev_cleanup)
                continue
            subtask = cleanup_2.Cleanup2(
                self,
                description="Cleanup host {}".format(host),
                priority=int(self.Parameters.subtasks_priority),
                kill_timeout=self.Parameters.subtasks_kill_timeout,
                tags=[host],
                run_in_dry_mode=False,
                _service_task_id=self.id,
                __requirements__={"host": host, "disk_space": 3000},
            )
            result = subtask.save().enqueue()
            logging.debug("Subtask for %s started: %s", host, result)
