import logging

import pathlib2


def embed_revision(init_module, rev):
    init_module = pathlib2.Path(init_module)
    logging.info("Embedding revision %r into file %r", rev, init_module)

    if init_module.exists():
        with init_module.open() as f:
            lines = f.readlines()
    else:
        lines = ["__revision__ = None\n"]

    with init_module.open("w") as f:
        written = False
        for line in lines:
            if line.startswith("__revision__"):
                f.write(u"__revision__ = {}\n".format(rev))
                written = True
            else:
                f.write(line)
        if not written:
            f.write(u"\n__revision__ = {}\n".format(rev))
