from sandbox import sdk2


class ParametersTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        checker = sdk2.parameters.Bool("Bool", default=False)
        with checker.value[True]:
            checker_true = sdk2.parameters.Dict("checker_true", description="checker_true")
        with checker.value[False]:
            checker_false = sdk2.parameters.Dict("checker_false", description="checker_false")

        with sdk2.parameters.RadioGroup("RadioGroup") as radiogroup:
            radiogroup.values[True] = radiogroup.Value("rg_true", default=True)
            radiogroup.values[False] = radiogroup.Value("rg_false")

            with radiogroup.value[True]:
                rg_true = sdk2.parameters.Integer("rg_true", description="rg_true")

            with radiogroup.value[False]:
                rg_false = sdk2.parameters.String("rg_false", description="rg_false")

    def on_execute(self):
        pass
