import datetime as dt

import sandbox.common.types.client as ctc

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.sandbox import http_upload_2


class MDSUpload(nanny.ReleaseToNannyTask2, release_integration.ReleaseToYaDeployTask2, sdk2.Task):
    """
    "Backend" task for resource upload via proxy.sandbox.yandex-team.ru to MDS.
    It should **not** be used directly, without :module:`common.upload` module.
    """
    name = "MDS_UPLOAD"

    class Requirements(sdk2.Requirements):
        client_tags = ctc.Tag.GENERIC | ctc.Tag.STORAGE
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(http_upload_2.HTTPUpload2.Parameters):
        expires = dt.timedelta(days=1)
        release_to_yd = release_integration.ReleaseToYaDeployParameter2()

    class Context(http_upload_2.HTTPUpload2.Context):
        pass

    def on_enqueue(self):
        if self.Requirements.resources:
            return
        attrs = {"backup_task": True}
        attrs.update(self.Parameters.resource_attrs)
        resource = sdk2.Resource[self.Parameters.resource_type](
            self,
            self.Parameters.description,
            "UNKNOWN",
            self.Parameters.resource_arch,
            **attrs
        )
        self.Requirements.resources = [resource]

    def on_execute(self):
        resource = self.Requirements.resources[0]
        sdk2.ResourceData(resource)
        self.Parameters.resource = resource

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)

        if self.Parameters.release_to_yd:
            release_integration.ReleaseToYaDeployTask2.on_release(self, additional_parameters)
