import logging

from sandbox import sdk2
from sandbox import common
from sandbox.agentr import errors as aerrors


class ReshareResource(sdk2.Task):
    class Requirements(sdk2.Requirements):
        disk_space = 50

    class Parameters(sdk2.Parameters):
        resource_id = sdk2.parameters.Resource(
            "Resource to reshare", required=True, register_dependency=True
        )

    def on_execute(self):
        try:
            self.agentr.reshare(self.Parameters.resource_id.id)
        except aerrors.ARException as exc:
            message = "Sharing of resource failed: {}".format(exc)
            logging.exception(message)
            raise common.errors.TaskFailure(message)
