from sandbox import sdk2
from sandbox.sdk2 import service_resources

from sandbox.projects.sandbox import teams

LXC_CONTAINER = service_resources.LxcContainer
LXC_CONTAINER.releasers = teams.CORE_TEAM
SandboxTasksArchive = service_resources.SandboxTasksArchive
SandboxTasksBinary = service_resources.SandboxTasksBinary
SandboxTasksImage = service_resources.SandboxTasksImage
TestTaskResource = service_resources.TestTaskResource
TestTaskResource2 = service_resources.TestTaskResource2


class SandboxArchive(sdk2.Resource):
    """
        Tarball with Sandbox code
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = teams.CORE_TEAM


class SandboxBinary(sdk2.Resource):
    """
        Binary of sandbox component
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = teams.CORE_TEAM


class SandboxSamogonPlugin(sdk2.Resource):
    """
        Tarball with Samogon plugin for Sandbox
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = teams.CORE_TEAM + teams.STATINFRA_TEAM


class SandboxDeps(sdk2.Resource):
    """
        Tarball with Sandbox virtual environment
    """
    auto_backup = True
    any_arch = False
    releasable = True
    releasers = teams.CORE_TEAM
    platform = sdk2.Attributes.String("Virtual environment platform")
    version = sdk2.Attributes.String("Virtual environment revision")
    to_be_released = sdk2.Attributes.String("Release tag this archive is built for")


class SandboxDocs(sdk2.Resource):
    """ static HTML with Sandbox documentation """
    auto_backup = True
    version = sdk2.parameters.Integer("Maximal revision no. of all components included")


class SandboxDocsAssets(sdk2.Resource):
    """ images and other assets for Sandbox documentation """
    auto_backup = True
    releasable = True
    releasers = teams.CORE_TEAM


class SandboxUploadScript(sdk2.Resource):
    """
        Self-extracting script to upload resources into Sandbox.
    """
    releasable = True
    executable = True
    auto_backup = True
    version = sdk2.parameters.String("Script's build revision number")


class SandboxUploadBinary(sdk2.Resource):
    """
        Binary tool for uploading local files to Sandbox resources
    """
    releasable = True
    executable = True
    auto_backup = True


class SandboxXmlrpcStatistics(sdk2.Resource):
    """
        JSON files with statistics built from Sandbox XMLRPC log files.
    """


class SandboxApiStatistics(sdk2.Resource):
    """
        JSON files with statistics built from Sandbox XMLRPC or REST log files.
    """


class SandboxTestResults(sdk2.Resource):
    """
        Results of sandbox server testing
    """
    calc_md5 = False
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False
    share = False


class SandboxPackage(sdk2.Resource):
    """
        Tarball with parts of Sandbox: server, client, virtual env, service q.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = teams.CORE_TEAM


class SandboxShardGroupBackup(sdk2.Resource):
    """ produced by ServiceMongoShardBackuper """
    auto_backup = True
    releasable = True
    releasers = teams.CORE_TEAM


class SandboxConfigServerBackup(sdk2.Resource):
    """ produced by ServiceMongoCfgBackuper """
    auto_backup = True
    releasable = True
    releasers = teams.CORE_TEAM


class SandboxMongoContainer(LXC_CONTAINER):
    """ container with MongoDB package installed """


class RemToStepConverter(sdk2.Resource):
    """
    REM tags to StEP events converter binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = teams.CORE_TEAM


class EventProcessor(sdk2.Resource):
    """
    Self-sufficient resource for deploing STEP, contains two archives: step.tgz and venv_step.tgz
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = teams.CORE_TEAM + teams.STATINFRA_TEAM


class SvnBinary(sdk2.Resource):
    """
    Svn binary built from Arcadia
    """
    revision = sdk2.Attributes.Integer("revision")
    platform = sdk2.Attributes.String("platform")
    version = sdk2.Attributes.String("version")


class AWSCLISFX(sdk2.Resource):
    """ AWS command-line tool (http://aws.amazon.com/cli/) in a single file """
    version = sdk2.Attributes.String("Tool version")
    releasers = teams.CORE_TEAM
    releasable = True


class QemuImageSandbox(sdk2.Resource):
    """
    QEMU image for local Sandbox (contains no Sandbox installed!)
    """

    platform = sdk2.Attributes.String("Image platform")
    releasers = teams.CORE_TEAM
    releasable = True


class QypSandboxWindows(sdk2.Resource):
    """
    QEMU windows-os image for qyp(contains no Sandbox installed!)
    """

    releasers = teams.CORE_TEAM
    releasable = True


class SandboxChecksBundle(sdk2.Resource):
    """
    Juggler checks for Sandbox
    """

    auto_backup = True
    releasers = teams.CORE_TEAM
    releasable = True


class SandboxSolomonAgentBinary(sdk2.Resource):
    """
    Solomon binary agent
    """

    auto_backup = True
    releasers = teams.CORE_TEAM
    releasable = True


class SandboxTasksBuildCache(sdk2.Resource):
    """
    An attempt to speed up tasks binary build (SANDBOX-6390)
    """

    revision = sdk2.parameters.Integer("Revision of Arcadia this cache is based on")
    ttl = 2
    releasers = teams.CORE_TEAM


class SandboxAtopBinary(sdk2.Resource):
    """
    Statically compiled Atop binary [DEVTOOLS-5669]
    """

    auto_backup = True
    releasers = teams.CORE_TEAM
    releasable = True


class SandboxEnvironmentBuilder(sdk2.Resource):
    """
    Binary that compiles virtual environment for Sandbox: sandbox/scripts/tools/virtualenv-builder/README.md
    """

    revision = sdk2.parameters.Integer("Revision of sources the binary is built from")
    platform = sdk2.parameters.String("Short platform name (for ex., \"osx_10.13_high_sierra\"")


class ExcavatorBinary(sdk2.Resource):
    """
    Excavator: the tool that simplifies the chores of Sandbox development
    """

    executable = True
    releasable = True
    arcadia_build_path = "sandbox/scripts/tools/excavator"


class SandboxPy3ModulesParser(sdk2.Resource):
    """ Resource with binary for parsing ya.make to find py3 libraries """
    auto_backup = True
    releasable = True
    releasers = teams.CORE_TEAM
    sync_upload_to_mds = True
    executable = True


class WindowsImdiskDriver(sdk2.Resource):
    """
    Driver installer for windows ramdisk driver ImDisk [SANDBOX-7858]
    """

    auto_backup = True
    releasers = teams.CORE_TEAM
    releasable = True


class CysonForSkynetPython(sdk2.Resource):
    """
    cyson bindings builded for skynet pthon [SANDBOX-8773]
    Buld by https://sandbox.yandex-team.ru/template/SandboxCysonForSkynet/
    """

    auto_backup = True
    releasers = teams.CORE_TEAM
    releasable = True
    sync_upload_to_mds = False


class SandboxResourceManager(sdk2.Resource):
    """
    Resource class with binary for Sandbox resource manager sidecar
    """
    auto_backup = True
    releasers = teams.CORE_TEAM
    releasable = True
    sync_upload_to_mds = True
