import logging

from sandbox import common
import sandbox.common.types.client as ctc
import sandbox.common.types.resource as ctr

from sandbox.agentr import errors as aerrors

from sandbox import sdk2


class RestoreResource(sdk2.Task):
    """ Restore resource on host if it is still there or could be synchronized. """

    class Requirements(sdk2.Requirements):
        client_tags = ctc.Tag.VOID

    class Parameters(sdk2.Parameters):
        resource_id = sdk2.parameters.Resource("Resource to restore", required=True, register_dependency=False)

    def on_execute(self):
        resource_id = self.Parameters.resource_id.id
        try:
            self.agentr.reshare(resource_id)
        except aerrors.ARException:
            logging.exception("Exception while resharing")
            raise common.errors.TaskFailure("Unable to restore resource #{}".format(resource_id))
        self.server.resource[resource_id].update(state=ctr.State.READY)
