from sandbox import sandboxsdk as sdk1

from sandbox.sdk2.vcs import svn


BRANCHES_PATH_PREFIX = "arcadia:/arc/branches/sandbox/"


class VCSBlock(sdk1.parameters.SandboxInfoParameter):
    description = "VCS checks"


class SvnSrcPath(sdk1.parameters.SandboxArcadiaUrlParameter):
    description = "Arcadia url to copy"
    name = "svn_tag_src_path"
    default_value = "arcadia:/arc/trunk/arcadia"


class SvnTagName(sdk1.parameters.SandboxStringParameter):
    description = "{}<svn tag name>".format(BRANCHES_PATH_PREFIX)
    name = "svn_tag_name"
    default_value = "acceptance_test_branch"


class CreateSvnTag(sdk1.parameters.SandboxBoolParameter):
    description = "Create svn tag"
    name = "create_svn_tag"
    sub_fields = {"true": [SvnSrcPath.name, SvnTagName.name]}


class SandboxAcceptanceSDK1(sdk1.task.SandboxTask):
    """ Sandbox acceptance task. It checks main SDK1 features to work properly. """

    type = "SANDBOX_ACCEPTANCE_SDK1"

    input_parameters = [
        VCSBlock,
        CreateSvnTag,
        SvnSrcPath,
        SvnTagName,
    ]

    @staticmethod
    def _create_svn_tag(src, branch):
        dst = "{}{}".format(BRANCHES_PATH_PREFIX, branch)
        if svn.Arcadia.list(dst):
            svn.Arcadia.delete(dst, message="Remove test branch", user=svn.Arcadia.RW_USER)
        svn.Arcadia.create_tag(
            src, dst, svn.Arcadia.RW_USER,
            message="Create new tag for Sandbox acceptance",
            parents=True,
        )

    def on_execute(self):
        if self.ctx[CreateSvnTag.name]:
            self._create_svn_tag(self.ctx[SvnSrcPath.name], self.ctx[SvnTagName.name])
