# This script will be executed after all of "host" bindings like `/dev` or `/proc` will be unmounted,
# just before the image will be packaged

apt-get clean
apt-get autoclean
rm -r /root/sbin || true
find /var/lib/apt/lists -type f -delete || true
find /var/cache/apt -type f -delete || true

# Ensure 512 loop devices are embedded into the image
[[ ! -e /dev/loop-control ]] && mknod -m660 /dev/loop-control c 10 237
for i in {0..511}; do [[ ! -e /dev/loop${i} ]] && mknod -m660 /dev/loop${i} b 7 ${i}; done
chown root:disk /dev/loop-control /dev/loop{0..511}

# Ensure kvm device exists with correct privileges
[[ ! -e /dev/kvm ]] && mknod /dev/kvm c 10 232
chown root:kvm /dev/kvm
chmod ug+rw /dev/kvm

# Ensure fuse device exists with correct privileges
[[ ! -e /dev/fuse ]] && mknod /dev/fuse c 10 229 || true  # for Precise only, I have no idea, whats wrong with it
chown root:fuse /dev/fuse
chmod a+rw /dev/fuse

# Ensure mtab exists
[[ ! -d /etc/mtab ]] || rm -rf /etc/mtab
[[ $(readlink /etc/mtab) == "../proc/self/mounts" ]] || ln -sf ../proc/self/mounts /etc/mtab
