import pwd
import os
import getpass
import logging
import multiprocessing

from sandbox import sdk2
from sandbox import common
from sandbox.sandboxsdk import environments


class SandboxLxcImageAcceptance(sdk2.Task):
    """
    Task to test Linux containers.
    https://st.yandex-team.ru/SANDBOX-3009
    """

    class Parameters(sdk2.Task.Parameters):
        lxc_resource = sdk2.parameters.Container("LXC container to test", required=True)
        privileged = sdk2.parameters.Bool("Run in a privileged container (under root privileges)", default=False)
        suspend_on_execute = sdk2.parameters.Bool("Suspend when entering on_execute()", default=False)

    def on_save(self):
        if self.Parameters.privileged:
            self.Requirements.privileged = True

    def on_execute(self):
        if self.Parameters.suspend_on_execute:
            self.suspend()

        if os.readlink("/etc/mtab") == "../proc/self/mounts":
            logging.info("/etc/mtab OK")
        else:
            raise common.errors.TaskFailure("/etc/mtab should be a symlink to ../proc/self/mounts")

        logging.info("Svn test")
        tmp_path = str(self.path("tmp"))
        sdk2.svn.Arcadia.checkout("arcadia:/arc/trunk/arcadia", tmp_path, depth="empty")
        logging.debug(sdk2.svn.Arcadia.info(tmp_path))
        logging.info("Tested")

        logging.info("'Call Vasya' test")
        user = getpass.getuser()
        logging.info("Check user '%s'", user)
        logging.info("%s", pwd.getpwnam(user))

        user = "vasiliy-pupkin-the-unknown"
        logging.info("Check user '%s'", user)
        try:
            info = pwd.getpwnam(user)
        except KeyError as error:
            logging.info("Tested. User '%s' is unknown: %s", user, error)
        else:
            raise common.errors.TaskFailure(
                "User '{}' check failed (there has been no exception, but it was expected): {}".format(user, info)
            )

        logging.info("Multiprocessing test")
        with multiprocessing.Lock():
            logging.info("Tested")

        with environments.VirtualEnvironment() as virtual_env:
            virtual_env.pack_bundle(str(self.path("tmp.tar.gz")))
