import sandbox.common.types.task as ctt
from sandbox import sdk2


class Parameters(sdk2.Task.Parameters):
    description = "Taskboxer!"

    int_param = sdk2.parameters.Integer("Integer parameter", default=42)
    str_param = sdk2.parameters.String("String parameter", default="str42")

    with sdk2.parameters.Output:
        result = sdk2.parameters.Integer("Answer to the Ultimate Question of Life, the Universe, and Everything")

    check_rest_from_server_hooks = sdk2.parameters.Bool("Check REST API requests from server hooks")
    raise_exception_on_hook = sdk2.parameters.String("Hook to raise exception", default="")


class Context(sdk2.Task.Context):
    some_number = 1

    on_create_done = False
    on_create_count = 0
    on_save_done = False
    on_save_count = 0
    on_enqueue_done = False
    on_enqueue_count = 0
    on_execute_count = 0


RELEASE_TEMPLATE = sdk2.ReleaseTemplate(
    cc=["robot", "zombie"],
    subject="Taskboxer release subject",
    message="Taskboxer release message",
    types=[ctt.ReleaseStatus.STABLE, ctt.ReleaseStatus.TESTING],
)
