import json

from sandbox import sdk2

from sandbox.projects.sandbox.taskboxer import internal


class TaskboxerTask(sdk2.Task):
    """ Binary task that can be used for testing server-side hooks executed in taskbox. """

    ON_ENQUEUE_WAIT_TIME = 5

    class Requirements(sdk2.Task.Requirements):
        container_resource = sdk2.parameters.Container("LXC container")

    class Parameters(internal.Parameters):
        pass

    class Context(internal.Context):
        pass

    @sdk2.report(title="Context report")
    def context_report(self):
        return "<pre>{}</pre>".format(json.dumps(self.Context.__values__, indent=4))

    @sdk2.footer()
    def taskboxer_footer(self):
        return "Taskboxer footer"

    @sdk2.header()
    def taskboxer_header(self):
        return "Taskboxer header"

    @property
    def release_template(self):
        return internal.RELEASE_TEMPLATE

    def on_create(self):
        if self.Parameters.raise_exception_on_hook == "on_create":
            raise TypeError("Type error on create")

        self.Context.on_create_done = True
        self.Context.on_create_count += 1

        if self.Parameters.check_rest_from_server_hooks:
            # Send dummy query parameter that cannot be serialized by messagepack.
            # Expect that it will be cast to a privitive type (SANDBOX-6858)
            self.Context.on_create_task_id_from_rest = self.server.task[self.id].read(dummy={"foo", "bar"})["id"]
            try:
                self.server.task[0][:]
            except self.server.HTTPError as ex:
                self.Context.on_create_non_existent_task_from_rest = ex.status
            try:
                self.server.upyachka[:]
            except self.server.HTTPError as ex:
                self.Context.on_create_non_existent_path_from_rest = ex.status
            try:
                self.server.task()
            except self.server.HTTPError as ex:
                self.Context.on_create_create_task_from_rest = ex.status

    def _update_tasks_resource(self):
        if self.Context.new_tasks_resource:
            self.Requirements.tasks_resource, self.Context.new_tasks_resource = self.Context.new_tasks_resource, None

    def on_save(self):
        if self.Parameters.raise_exception_on_hook == "on_save":
            raise KeyError("Key error on save")

        self.Context.on_save_done = True
        self.Context.on_save_count += 1

        if self.Parameters.check_rest_from_server_hooks:
            self.Context.on_save_task_id_from_rest = self.server.task[self.id].read(dummy={"foo", "bar"})["id"]
            try:
                self.server.task[0][:]
            except self.server.HTTPError as ex:
                self.Context.on_save_non_existent_task_from_rest = ex.status
            try:
                self.server.upyachka[:]
            except self.server.HTTPError as ex:
                self.Context.on_save_non_existent_path_from_rest = ex.status
            try:
                self.server.task()
            except self.server.HTTPError as ex:
                self.Context.on_save_create_task_from_rest = ex.status

        self._update_tasks_resource()

    def on_enqueue(self):
        if self.Parameters.raise_exception_on_hook == "on_enqueue":
            raise ValueError("Value error on enqueue")

        self.Context.on_enqueue_count += 1

        if self.Parameters.check_rest_from_server_hooks:
            self.Context.on_enqueue_task_id_from_rest = self.server.task[self.id].read(dummy={"foo", "bar"})["id"]
            try:
                self.server.task[0][:]
            except self.server.HTTPError as ex:
                self.Context.on_enqueue_non_existent_task_from_rest = ex.status
            try:
                self.server.upyachka[:]
            except self.server.HTTPError as ex:
                self.Context.on_enqueue_non_existent_path_from_rest = ex.status
            try:
                self.server.task()
            except self.server.HTTPError as ex:
                self.Context.on_enqueue_create_task_from_rest = ex.status

        self._update_tasks_resource()

        if not self.Context.on_enqueue_done:
            self.Context.on_enqueue_done = True
            raise sdk2.WaitTime(self.ON_ENQUEUE_WAIT_TIME)

    def on_execute(self):
        self.Context.on_execute_count += 1

        self.Parameters.result = 42
