# coding: utf-8

from sandbox import sdk2
from sandbox import common

import sandbox.common.types.misc as ctm
import sandbox.common.types.task as ctt


class TaskletAcceptance(sdk2.Task):
    """ Launch and wait acceptance tasklet, check it output parameters """

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        disk_space = 2

        class Caches(sdk2.Requirements.Caches):
            pass  # no shared caches

    class Parameters(sdk2.Parameters):
        description = "Launch acceptance tasklet"
        kill_timeout = 180

    def on_execute(self):
        tasklet_binary = sdk2.service_resources.SandboxTasksBinary.find(
            attrs={"tasklet_name": "tasklet_acceptance", "released": "stable"}
        ).first()

        parameters = {
            "num": 5,
            "str": "test",
            "flag": True
        }

        with self.memoize_stage.run_tasklet_acceptance:
            response = self.server.task.create(
                type="TASKLET_TASKLET_ACCEPTANCE", owner=self.owner, description="Acceptance tasklet",
                requirements={"tasks_resource": tasklet_binary.id},
                custom_fields=[{"name": key, "value": value} for key, value in parameters.items()],
                children=True
            )

            task_id = response["id"]
            start_result = self.server.batch.tasks.start.update([task_id])[0]
            status, message = map(start_result.get, ("status", "message"))
            if status == ctm.BatchResultStatus.ERROR:
                raise common.errors.TaskError("Can't run subtask {}: {}".format(task_id, message))
            self.Context.acceptance_tasklet_id = task_id
            raise sdk2.WaitTask([task_id], ctt.Status.Group.FINISH + ctt.Status.Group.BREAK)

        acceptance_tasklet = self.server.task[self.Context.acceptance_tasklet_id].read()
        output_parameters = acceptance_tasklet["output_parameters"]["__tasklet_output__"]
        assert parameters == output_parameters, "There is difference between input {} and output {}".format(
            parameters, output_parameters
        )
