from sandbox import sdk2

from sandbox.projects.sandbox import teams


class BaseTaskletServiceResource(sdk2.Resource):
    __abstract__ = True

    releasable = True
    releasers = teams.TASKLET_TEAM
    auto_backup = True


class TaskletsDeployArchive(BaseTaskletServiceResource):
    """
        Resource with deploy layer for Tasklets
    """


class TaskletExecutorBinary(BaseTaskletServiceResource):
    """
        Tasklet executor binary creates environment for tasklet and spawns tasklet subprocess
    """


class TaskletTool(BaseTaskletServiceResource):
    """
        Tasklet tool binary for using tasklet
    """
    releasable = True
    auto_backup = True


class TaskletExecutionLogs(sdk2.service_resources.TaskCustomLogs):
    """
        Resource with logs of tasklet launch
    """
    auto_backup = True


class TaskletExecutable(sdk2.resource.AbstractResource):
    """
        Default tasklet build executable resource
    """
    releasable = True
    auto_backup = True


class TaskletSchema(sdk2.resource.Resource):
    """
        Tasklet schema FDS
    """
    releasable = True
    auto_backup = True
