# -*- coding: utf-8 -*-


def in_case_of(prop, method_name):
    """
    Вызывает либо базовый метод, либо его fallback, если указанный property возвращает не falsey значения

    :param prop: название property таски
    :type prop: str
    :param method_name: название метода
    :type method_name: str
    :rtype: func
    """
    def decorate(func):
        def wrap(self, *args, **kwargs):
            if getattr(self, prop, False):
                fallback_func = getattr(self, method_name)
                return fallback_func(*args, **kwargs)

            return func(self, *args, **kwargs)

        return wrap

    return decorate
