# -*- coding: utf-8 -*-

import time
import logging


def exec_with_retries(fn, retries_count, delay):
    try:
        return fn()
    except Exception as e:
        if retries_count:
            logging.debug('retriable function failed with error {}, left {} retries, will retry in {} sec'.format(e, retries_count, delay))
            time.sleep(delay)
            return exec_with_retries(fn, retries_count - 1, delay)

        raise e


def retriable(retries_count=7, delay=5):
    """
    Выполняет метод с ретраями в случае возникновения исключения

    :param retries_count: количество ретраев
    :type retries_count: int
    :param delay: задержка перед каждым ретраем в секундах
    :type delay: int
    :rtype: func
    """
    def decorate(func):
        def wrap(self, *args, **kwargs):
            return exec_with_retries(lambda: func(self, *args, **kwargs), retries_count, delay)

        return wrap

    return decorate
