# -*- coding: utf-8 -*-


def skip_subtask(task_type, description):
    """
    Проверяет необходимость пропуска создания задачи. Возвращает None, если задачу можно не создавать.

    :param task_type: экземпляр класса таски
    :type task_type: sandbox.projects.sandbox_ci.task.BaseTask.BaseTask
    :param description: описание github статуса
    :type description: str
    :rtype: None
    """
    def decorate(func):
        def wrap(master_task, *args, **kwargs):
            task_label = getattr(task_type, 'task_label', None)

            if not master_task.need_to_skip_check(task_label):
                return func(master_task, *args, **kwargs)

            master_task.meta.skip_step(
                github_context=task_type.github_context,
                description=description,
                label=task_label,
                reason='not modified',
            )

            return None
        return wrap
    return decorate
