# -*- coding: utf-8 -*-

import logging
from sandbox.common.types import misc as ctm
from sandbox import sdk2

from sandbox.projects.sandbox_ci.task import ManagersTaskMixin
from sandbox.projects.sandbox_ci import parameters


class InfratestDobbyBase(ManagersTaskMixin, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        node_js = parameters.NodeJsParameters

    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.DNS64
        disk_space = 3 * 1024

    class Context(sdk2.Context):
        noncritical_errors = []
        report_resources = []
        reused_resources = []

    @sdk2.header()
    def header(self):
        report = {}

        report_ids = self.Context.report_resources
        if report_ids:
            report.update(**self.task_reports.reports_artifacts(report_ids))

        return report

    def on_execute(self):
        logging.info('start to execute dobby task')
