# -*- coding: utf-8 -*-

import logging
from sandbox.common.types import misc as ctm
from sandbox import sdk2

from sandbox.projects.sandbox_ci.task import ManagersTaskMixin
from sandbox.projects.sandbox_ci.infrastats.date_util import fill_date_variants
from sandbox.projects.sandbox_ci.task.binary_task import TasksResourceRequirement
from sandbox.projects.sandbox_ci import parameters


class InfratestInfrastatsBase(TasksResourceRequirement, ManagersTaskMixin, sdk2.Task):
    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.DNS64
        disk_space = 3 * 1024

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group('Filter parameters') as filter_block:
            with sdk2.parameters.String('Date From', required=True) as date_from:
                date_from.values['today'] = date_from.Value('Start of Today', default=True)
                fill_date_variants(date_from)

            with sdk2.parameters.String('Date To', required=True) as date_to:
                date_to.values['now'] = date_to.Value('Now', default=True)
                fill_date_variants(date_to)

            with sdk2.parameters.String('Branch') as branch:
                branch.values['all'] = branch.Value('All', default=True)
                branch.values['dev'] = branch.Value('Only dev')

        node_js = parameters.NodeJsParameters

    class Context(sdk2.Context):
        noncritical_errors = []
        report_resources = []
        reused_resources = []

    @sdk2.header()
    def header(self):
        report = {}

        report_ids = self.Context.report_resources
        if report_ids:
            report.update(**self.task_reports.reports_artifacts(report_ids))

        return report

    def on_execute(self):
        logging.info('start to execute infrastats task')
