# -*- coding: utf-8 -*-
import logging

from sandbox.common.types import misc as ctm
from sandbox import sdk2

from sandbox.projects.sandbox_ci.task import ManagersTaskMixin

from sandbox.sandboxsdk.environments import PipEnvironment

RESOURCE_TYPE = 'json-reporter'

CLICKHOUSE_DB = 'tests'
CLICKHOUSE_HOST = 'vla-4729cn2jora9xcyd.db.yandex.net'
CLICKHOUSE_PORT = 8443


class InfratestInfrastatsClickhoused(ManagersTaskMixin, sdk2.Task):
    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.DNS64
        disk_space = 3 * 1024
        environments = (PipEnvironment('clickhouse_driver'),)

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group('Filter parameters') as filter_block:
            with sdk2.parameters.String('Branch') as branch:
                branch.values['dev'] = branch.Value('Only dev', default=True)
                branch.values['all'] = branch.Value('All')

            with sdk2.parameters.RadioGroup('Project') as project:
                project.values['web4'] = project.Value('web4', default=True)
                project.values['fiji'] = 'fiji'
                project.values['nerpa'] = 'nerpa'
                project.values['turbo'] = 'turbo'
                project.values['chat'] = 'chat'

            with sdk2.parameters.String('Service (fiji only)') as service:
                service.values[''] = service.Value('---', default=True)
                service.values['images'] = service.Value('Images')
                service.values['video'] = service.Value('Video')

            ignore_tags = sdk2.parameters.List('Ignore tags', sdk2.parameters.String)

    class Context(sdk2.Context):
        report_resources = []

    @sdk2.header()
    def header(self):
        report = {}

        return report

    """
    Наличие свойста "project_name" и методов "project_dir", "working_path", "project_path"
    обусловлено желанием по максимуму использовать существующую функциональность
    из sandbox.projects.sandbox_ci.managers. Но код модулей managers предполагает использование
    совместно с sandbox.projects.sandbox_ci.task.BaseTask. И чтобы реиспользовать код пришлось
    добавить и переопределить вышеуказанные свойства и методы в данной задаче.
    """
    @property
    def project_name(self):
        return ''

    @property
    def project_dir(self):
        return self.working_path()

    def working_path(self, *args):
        return self.path(*args)

    def project_path(self, *args):
        return self.project_dir.joinpath(*args)

    @property
    def clickhouse(self):
        if hasattr(self, '_clickhouse'):
            return self._clickhouse

        from clickhouse_driver import Client

        user = self.vault.read('env.SEARCH_INTERFACES_CLICKHOUSE_USER')
        password = self.vault.read('env.SEARCH_INTERFACES_CLICKHOUSE_PASSWORD')

        self._clickhouse = Client(
            host=CLICKHOUSE_HOST,
            port=CLICKHOUSE_PORT,
            user=user,
            password=password,
            database=CLICKHOUSE_DB,
        )

        return self._clickhouse

    def clickhouse_execute(self, query, args=None):
        return self.clickhouse.execute(query, args)

    def on_execute(self):
        logging.info('Start to execute infrastats clickhoused task')

        res = self.clickhouse_execute('SHOW TABLES from tests')
        logging.info('clickhouse result = {}'.format(res))
