# -*- coding: utf-8 -*-

from datetime import datetime
from datetime import timedelta
from dateutil import tz
import re

HOURS = [1, 2, 3, 4, 5, 6, 9, 12, 15, 18, 21]
DAYS = [1, 2, 3, 4, 5, 6]
WEEKS = [1, 2, 3]


def get_start_of_today():
    today = datetime.utcnow().date()
    return datetime(today.year, today.month, today.day, tzinfo=tz.tzutc())


def get_multiplier(dimension):
    multiplier = 60 * 60 * 1000

    return {
        'd': multiplier * 24,
        'w': multiplier * 24 * 7
    }.get(dimension, multiplier)


def parse_date(date_str):
    if date_str == 'now':
        return datetime.now()

    if date_str == 'today':
        return get_start_of_today()

    match = re.match(r"(\d+)(h|d|w)", date_str)

    value = int(match.group(1))
    dimension = match.group(2)

    return _calculate_subtracted_date(value, dimension)


def _calculate_subtracted_date(value, dimension):
    return datetime.now() - timedelta(milliseconds=(value * get_multiplier(dimension)))


def format_to_iso(dt):
    return dt.isoformat()


def convert_to_date(date_str):
    return format_to_iso(parse_date(date_str))


def fill_date_variants(target):
    for number in HOURS:
        target.values['{}h'.format(number)] = '{} hour(s) ago'.format(number)

    for number in DAYS:
        target.values['{}d'.format(number)] = '{} day(s) ago'.format(number)

    for number in WEEKS:
        target.values['{}w'.format(number)] = '{} week(s) ago'.format(number)
