# -*- coding: utf-8 -*-

import ast
import datetime
import dateutil.parser as date_parser
import re

from sandbox.projects.sandbox_ci.utils.request import send_request

submitter = 'zomb-sandbox-rw'


def get_children(node, clazz):
    nodes = list()
    for nn in ast.iter_child_nodes(node):
        if isinstance(nn, clazz):
            nodes.append(nn)
    return nodes


def get_releasers(class_node):
    assign = get_children(class_node, ast.Assign)
    rel = filter(lambda a: a.targets[0].id == 'releasers', assign)[0].value

    releaser_items = list()
    for item in ast.walk(rel):
        if isinstance(item, ast.Str):
            releaser_items.append(item.s)
    return releaser_items


def get_packages(tree, package_to_create):
    p_nodes = get_children(tree, ast.ClassDef)

    all_packages = dict()
    for p in p_nodes:
        name = unicode(p.name)
        releasers = package_to_create['releasers'] if package_to_create['name'] == name else get_releasers(p)
        all_packages[name] = releasers

    if package_to_create['name'] not in all_packages:
        all_packages[package_to_create['name']] = package_to_create['releasers']

    return all_packages


def generate_content(content, package_to_create):
    new_content = '# -*- coding: utf-8 -*-\n\
\n\
# Данный файл содержит типы ресурсов для проектов монорепо frontend,\n\
# сгенерированные при помощи команды пакета apphost-service.\n\
# Файл изменяется только при помощи утилиты, сделанные вручную изменения будут утеряны.\n\
\n\
from releasers import *\n\
from template_packages import ReportWebTemplatesPackage\n'

    tree = ast.parse(content)
    packages = get_packages(tree, package_to_create)

    for name in sorted(packages.keys()):
        releasers_list = ', '.join(map(lambda r: '\'{}\''.format(r), packages[name]))
        class_descr = '\n\nclass {}(ReportWebTemplatesPackage):\n    releasers = [{}] + ROBOTS + INFRA_TEAM\n'.format(
            name, releasers_list)
        new_content += class_descr

    return new_content


def find_review(summary, token):
    limit = 1000
    offset = 0

    while True:
        url = 'https://a.yandex-team.ru/api/review/dashboard?view=raw&status=pending_review' \
              '&limit={}&offset={}&submitter={}&sort=-id'\
            .format(limit, offset, submitter)
        response = send_request('get', url, headers={
            'Authorization': 'OAuth ' + token
        }, verify=False)
        reviews = response.json()['reviews']

        # Не смотрим в ревью старше 7 дней
        rr_created = date_parser.parse(reviews[0]['timeAdded'])
        now = datetime.datetime.now(rr_created.tzinfo)
        delta = now - rr_created
        if delta.days > 7:
            break

        similar_reviews = filter(lambda r: r['summary'] == summary, reviews)
        if len(similar_reviews) is not 0:
            return str(similar_reviews[0][u'id'])

        if len(reviews) < limit:
            break

        offset += limit


def parse_pr(out):
    matches = re.search('^.*https://a.yandex-team.ru/review/(\d+)', out, re.MULTILINE)
    if matches:
        return matches.group(1)
