# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.common.errors import TaskFailure
from sandbox.common.types import task as ctt
from sandbox.common.types import misc as ctm

from sandbox.projects.sandbox_ci.infratest.integration.task_managers_factory import create_task_manager
from sandbox.projects.sandbox_ci.task import ManagersTaskMixin
from sandbox.projects.sandbox_ci.utils import prioritizer


class InfratestIntegrationTests(ManagersTaskMixin, sdk2.Task):
    """
        Таск запуска интеграционных тестов инструментов тестирования
    """

    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.DNS64
        disk_space = 1024  # 1 Gb

    class Parameters(sdk2.Parameters):
        branch = sdk2.parameters.String('Тестируемая ветка')
        with sdk2.parameters.String('Тестируемый инструмент') as test_tool:
            test_tool.values['gemini'] = 'gemini'
            test_tool.values['hermione'] = 'hermione'

    class Context(sdk2.Context):
        noncritical_errors = []
        failed_tasks = []

    def on_save(self):
        super(InfratestIntegrationTests, self).on_save()
        self.Parameters.priority = prioritizer.get_priority(self)

    def on_execute(self):
        task_manager = create_task_manager(
            self.Parameters.branch,
            self.meta,
            self.artifacts,
            self.Parameters.test_tool
        )

        with self.memoize_stage.mk_subtasks:
            subtasks = task_manager.create_subtasks()

            raise sdk2.WaitTask(
                tasks=self.meta.start_subtasks(subtasks),
                statuses=ctt.Status.Group.FINISH | ctt.Status.Group.BREAK
            )

        with self.memoize_stage.process:
            failed_subtasks = self.meta.failed_subtasks

            if failed_subtasks:
                self.meta.store_failed_tasks(failed_subtasks)

                raise TaskFailure('Has failed subtasks, see reports for more details')
