# -*- coding: utf-8 -*-

from sandbox.projects.sandbox_ci.utils import env
from sandbox.projects.sandbox_ci.infratest.integration.base_task_manager import BaseTaskManager


class GeminiTaskManager(BaseTaskManager):
    def __init__(self, branch, meta, artifacts):
        self.tool_name = 'gemini'

        self.tasks = {
        }

        super(GeminiTaskManager, self).__init__(branch, meta, artifacts)

    def get_custom_command(self, project):
        super_cmds = super(GeminiTaskManager, self).get_custom_command(project)

        # генерим клиентские скрипты
        return '{} && cd node_modules/{} && npm i'.format(super_cmds, self.tool_name)

    @property
    def environ(self):
        return env.merge([
            super(GeminiTaskManager, self).environ,
            {'gemini_system_plugins_faildump': 'false'}
        ])
