# -*- coding: utf-8 -*-

from sandbox.projects.sandbox_ci.utils import env
from sandbox.projects.sandbox_ci.infratest.integration.base_task_manager import BaseTaskManager
from sandbox.projects.sandbox_ci.sandbox_ci_fiji_hermione import SandboxCiFijiHermione


class HermioneTaskManager(BaseTaskManager):
    def __init__(self, branch, meta, artifacts):
        self.tool_name = 'hermione'

        self.tasks = {
            'fiji': SandboxCiFijiHermione,
        }

        super(HermioneTaskManager, self).__init__(branch, meta, artifacts)

    @property
    def environ(self):
        return env.merge([
            super(HermioneTaskManager, self).environ,
            {'hermione_plugins_faildump': 'false'}
        ])
