# -*- coding: utf-8 -*-

from sandbox.common.errors import TaskFailure

from sandbox.projects.sandbox_ci.infratest.integration.gemini import GeminiTaskManager
from sandbox.projects.sandbox_ci.infratest.integration.hermione import HermioneTaskManager


def create_task_manager(branch, meta, artifacts, test_tool):
    if test_tool == 'gemini':
        return GeminiTaskManager(branch, meta, artifacts)
    elif test_tool == 'hermione':
        return HermioneTaskManager(branch, meta, artifacts)
    else:
        raise TaskFailure('Cannot create task manager for tool {}'.format(test_tool))
