# -*- coding: utf-8 -*-

from sandbox import sdk2
import urllib
import requests
import logging
import json
import datetime as dt

from sandbox.sandboxsdk.environments import PipEnvironment

from sandbox.projects.sandbox_ci.task.ManagersTaskMixin import ManagersTaskMixin


class InfratestJavaStats(ManagersTaskMixin, sdk2.Task):
    """
        Таск сбора количества java-тестов Серпа
    """

    class Requirements(sdk2.Requirements):
        environments = (
            PipEnvironment('python-statface-client', custom_parameters=["requests==2.18.4"]),
        )

    _session = None

    @property
    def session(self):
        if self._session is None:
            session = requests.Session()
            session.mount('https://', requests.adapters.HTTPAdapter(max_retries=5))
            testpalm_api_token = self.vault.read('env.palmsync_token')
            session.headers.update({'Testpalm-Api-Token': testpalm_api_token})
            self._session = session
        return self._session

    def on_execute(self):
        data = {p: self.get_testcases_count_by_platform(p) for p in platforms}
        self.report_data(data)

    def report_data(self, data):
        logging.info('testpalm testcases count: %s', data)

        report_data = []
        for p in platforms:
            record = data[p].copy()
            record.update(
                task_id=self.id,
                fielddate=dt.datetime.now().strftime('%Y-%m-%d'),
                platform=p,
            )
            report_data.append(record)

        report = self.statface.get_report('Yandex.Productivity/infratest/web4/java/tests-count-vteam')
        report.upload_data(
            scale='d',
            data=report_data,
            request_kwargs=dict(timeout=60),
            _request_timeout=60
        )

    @staticmethod
    def get_filters(platform):
        """
        TODO: use platform to make correct filters
        :param platform:
        :return:
        """
        return filters_by_platform.get(platform)

    @staticmethod
    def get_url(filters):
        return 'https://testpalm-prod.yandex-team.ru/api/testcases/serp/groups?expression={}&groups={}'.format(
            urllib.quote_plus(json.dumps(filters)),
            '57a4546fc612334494811042',  # группировка по v-team
        )

    def get_testcases(self, url):
        logging.debug('testpalm url: %s', url)
        res = self.session.get(url, timeout=(3.05, 27))
        return res.json() if res.status_code == 200 else []

    def get_testcases_count_by_vteam(self, url):
        groups = self.get_testcases(url).get('groups', [])
        vteams = {}
        for group in groups:
            vteam_id = get_vteam_by_path(group.get('path'))
            if not vteam_id:
                continue
            vteams[vteam_id] = group.get('count', 0)
        return vteams

    def get_testcases_count_by_platform(self, platform):
        return self.get_testcases_count_by_vteam(self.get_url(self.get_filters(platform)))


def get_vteam_by_path(p):
    if not p[0]:
        return None
    return vteam_id_by_name.get('/'.join(p))


vteam_id_by_name = {
    u'Гео': 'geo',
    u'Дистрибуция': 'distribution',
    u'Красота': 'beauty',
    u'Объектный ответ': 'object_answer',
    u'Саджест_Свежесть': 'suggest_freshness',
    u'Скорость': 'velocity',
    u'ShinySerp': 'shiny_serp',
    u'AnswerOnSerp': 'answer_on_serp',
    u'Картинки': 'images',
    u'Видео': 'video',
    u'Translations and misspell': 'translation_and_misspell',
    u'Vertical': 'vertical',
    u'Веб-мастер': 'webmaster',
    u'Техно': 'techno',
    u'Constructives': 'constructives',
    # u'Функциональность': 'functionality',
    # u'Platform': 'platform',
    # u'Infratools': 'infratools',
    # u'Приложение': 'searchapp',
}

platforms = ['desktop', 'touch-pad', 'touch-phone']

filters_by_platform = {
    # desktop
    # https://testpalm.yandex-team.ru/serp/testcases?filters=%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22NEQ%22,%22key%22:%22status%22,%22value%22:%22archived%22%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d50efe4b0f81c89c3f9c5%22,%22value%22:null%7D%7D,%22right%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:null%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:%22%D0%9D%D0%B5%20%D1%82%D1%80%D0%B5%D0%B1%D1%83%D1%8E%D1%82%D1%81%D1%8F%22%7D%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:%22%D0%9D%D0%B5%20%D1%82%D1%80%D0%B5%D0%B1%D1%83%D1%8E%D1%82%D1%81%D1%8F_Desktop%22%7D%7D%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.56584e2288955038ade10427%22,%22value%22:%22Isles%22%7D%7D
    'desktop': {
        'type': 'AND',
        'left': {
            'type': 'AND',
            'left': {
                'type': 'AND',
                'left': {
                    'type': 'NEQ',
                    'key': 'status',
                    'value': 'archived'
                },
                'right': {
                    'type': 'NEQ',
                    'key': 'attributes.558d50efe4b0f81c89c3f9c5',
                    'value': None
                }
            },
            'right': {
                'type': 'AND',
                'left': {
                    'type': 'AND',
                    'left': {
                        'type': 'NEQ',
                        'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                        'value': None
                    },
                    'right': {
                        'type': 'NEQ',
                        'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                        'value': 'Не требуются'
                    }
                },
                'right': {
                    'type': 'NEQ',
                    'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                    'value': 'Не требуются_Desktop'
                }
            }
        },
        'right': {
            'type': 'NEQ',
            'key': 'attributes.56584e2288955038ade10427',
            'value': 'Isles'
        }
    },

    # touch-pad
    # https://testpalm.yandex-team.ru/serp/testcases?filters=%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22NEQ%22,%22key%22:%22status%22,%22value%22:%22archived%22%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.5593c9dae4b07248316146d3%22,%22value%22:null%7D%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:null%7D%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:%22%D0%9D%D0%B5%20%D1%82%D1%80%D0%B5%D0%B1%D1%83%D1%8E%D1%82%D1%81%D1%8F%22%7D%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:%22%D0%9D%D0%B5%20%D1%82%D1%80%D0%B5%D0%B1%D1%83%D1%8E%D1%82%D1%81%D1%8F_Tablet%22%7D%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.591f153788955074be0f77a3%22,%22value%22:%22Isles%22%7D%7D
    'touch-pad': {
        'type': 'AND',
        'left': {
            'type': 'AND',
            'left': {
                'type': 'AND',
                'left': {
                    'type': 'AND',
                    'left': {
                        'type': 'AND',
                        'left': {
                            'type': 'NEQ',
                            'key': 'status',
                            'value': 'archived'
                        },
                        'right': {
                            'type': 'NEQ',
                            'key': 'attributes.5593c9dae4b07248316146d3',
                            'value': None
                        }
                    },
                    'right': {
                        'type': 'NEQ',
                        'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                        'value': None
                    }
                },
                'right': {
                    'type': 'NEQ',
                    'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                    'value': 'Не требуются'
                }
            },
            'right': {
                'type': 'NEQ',
                'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                'value': 'Не требуются_Tablet'
            }
        },
        'right': {
            'type': 'NEQ',
            'key': 'attributes.591f153788955074be0f77a3',
            'value': 'Isles'
        }
    },

    # touch-phone
    # https://testpalm.yandex-team.ru/serp/testcases?filters=%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22NEQ%22,%22key%22:%22status%22,%22value%22:%22archived%22%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.55e58d2ae4b088a0482b880a%22,%22value%22:null%7D%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:null%7D%7D,%22right%22:%7B%22type%22:%22AND%22,%22left%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:%22%D0%9D%D0%B5%20%D1%82%D1%80%D0%B5%D0%B1%D1%83%D1%8E%D1%82%D1%81%D1%8F%22%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.558d5102e4b0f81c89c3f9c7%22,%22value%22:%22%D0%9D%D0%B5%20%D1%82%D1%80%D0%B5%D0%B1%D1%83%D1%8E%D1%82%D1%81%D1%8F_Touch%22%7D%7D%7D,%22right%22:%7B%22type%22:%22NEQ%22,%22key%22:%22attributes.56584e4bc6123378bff189f2%22,%22value%22:%22Isles%22%7D%7D
    'touch-phone': {
        'type': 'AND',
        'left': {
            'type': 'AND',
            'left': {
                'type': 'AND',
                'left': {
                    'type': 'AND',
                    'left': {
                        'type': 'NEQ',
                        'key': 'status',
                        'value': 'archived'
                    },
                    'right': {
                        'type': 'NEQ',
                        'key': 'attributes.55e58d2ae4b088a0482b880a',
                        'value': None
                    }
                },
                'right': {
                    'type': 'NEQ',
                    'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                    'value': None
                }
            },
            'right': {
                'type': 'AND',
                'left': {
                    'type': 'NEQ',
                    'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                    'value': 'Не требуются'
                },
                'right': {
                    'type': 'NEQ',
                    'key': 'attributes.558d5102e4b0f81c89c3f9c7',
                    'value': 'Не требуются_Touch'
                }
            }
        },
        'right': {
            'type': 'NEQ',
            'key': 'attributes.56584e4bc6123378bff189f2',
            'value': 'Isles'
        }
    }
}
