# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.types import misc as ctm

from sandbox.projects.sandbox_ci import parameters
from sandbox.projects.sandbox_ci.task.binary_task import TasksResourceRequirement

from .lib.scheduler import Scheduler
from .lib.publisher import Publisher
from .lib.header import get_header


class Npmify(TasksResourceRequirement, sdk2.Task):
    """
        Задача для публикации артефактов из аркадии в npm
    """
    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.LOCAL

    class Parameters(sdk2.Parameters):
        sandbox_container = parameters.environment_container()
        with sdk2.parameters.Group('Publish parameters') as publish_block:
            default_package_version = sdk2.parameters.String('Default package version', required=False)
            recipes = sdk2.parameters.JSON('Packages build config', default=[], description='', required=True)
            npm_username = sdk2.parameters.String('NPM username', required=True)
            npm_password_secret = sdk2.parameters.YavSecret('Yav secret with NPM password', required=True)
            npm_password_secret_key = sdk2.parameters.String('NPM password secret key', default='password', required=True)

        node_js = parameters.NodeJsParameters

    def on_execute(self):
        with self.memoize_stage.init:
            self.Context.scheduler_state = Scheduler.init(
                self.Parameters.recipes,
                self.Parameters.default_package_version
            )

        publisher_path = self.path('publisher')
        publisher_path.mkdir(parents=True, exist_ok=True)
        publisher = Publisher(
            username=self.Parameters.npm_username,
            password_secret=self.Parameters.npm_password_secret,
            password_secret_key=self.Parameters.npm_password_secret_key,
            publisher_path=publisher_path,
            node_js_version=self.Parameters.node_js_version
        )

        scheduler = Scheduler(self, publisher, self.Context.scheduler_state)
        scheduler.process()

    @sdk2.header()
    def header(self):
        return get_header(self.Context.scheduler_state.get('summary', []))
