# -*- coding: utf-8 -*-

from sandbox import sdk2


class BaseBuilder(object):
    '''
    Базовый класс для builders.
    Атрибуты `_package_params`, `_build_params`, `_task` и все методы
    могут быть использованы в классах-наследниках.
    '''

    def __init__(self, package_params, build_params, task, data):
        self._package_params = package_params
        self._build_params = build_params
        self._task = task
        self.__meta = data['meta']
        self.__store = data['store']

    def build(self):
        # BaseBuilder can be used as noop
        self._done()

    def _memoize_stage(self, stage_name):
        stage = 'builder-{}-{}'.format(self.__meta['id'], stage_name)
        return self._task.memoize_stage[stage]

    def _set(self, key, value):
        self.__store[key] = value
        return value

    def _get(self, key):
        return self.__store[key]

    def _memoize_tasks(self, key, tasks):
        self._set(key, map(int, tasks))
        return tasks

    def _memoize_task(self, key, task):
        self._set(key, task.id)
        return task

    def _restore_tasks(self, key):
        task_ids = self._get(key)
        return [task for task in sdk2.Task.find(id=task_ids)]

    def _restore_task(self, key):
        task_id = self._get(key)
        return sdk2.Task[task_id]

    def _restore_task_ids(self, key):
        return self._get(key)

    def _restore_task_id(self, key):
        return self._get(key)

    def _get_task_resource_by_type(self, task_id, resource_type):
        return sdk2.Resource[resource_type].find(task_id=int(task_id)).first()

    def _done(self, *results):
        raise BuildDone(results)


class BuildDone(Exception):
    def __init__(self, results):
        self.results = results
