# -*- coding: utf-8 -*-


class BaseComposer(object):
    '''
    Базовый класс для composers.
    Атрибуты `_package_params`, `_compose_params`, `_task` и все методы, кроме `compose`
    могут быть использованы в классах-наследниках.
    '''

    def __init__(self, package_params, compose_params, task):
        self._package_params = package_params
        self._compose_params = compose_params
        self._task = task

    def compose(self):
        raise Exception('Unexpected usage of base composer.')

    def _get_path(self):
        path = self._task.path('composers', self._package_params['name'], self._package_params['version'])
        path.mkdir(parents=True)
        return path
