def get_header(summary):
    return {'<h3 id="publish-status">Publish status</h3>': _get_status(summary)}


def _get_status(summary):
    return map(_get_package_status, summary)


def _get_package_status(package_summary):
    status, name = package_summary
    return {
        'status': _get_status_badge(status),
        'package': _get_description(name),
    }


def _get_status_badge(status):
    status_badge = {
        True: '<span class="status status_success">success</span>',
        False: '<span class="status status_failure">failure</span>'
    }
    return status_badge[status]


def _get_description(name):
    return '<a href="https://npm.yandex-team.ru/{name}" target="_blank">{name}</a>'.format(name=name)
