# -*- coding: utf-8 -*-

from sandbox.projects.sandbox_ci.utils.context import Node
from ..utils import copy_static, run_process


class Publisher(object):

    def __init__(
        self,
        username,
        password_secret,
        password_secret_key,
        publisher_path,
        node_js_version
    ):
        self._npm_username = username
        self._npm_password_secret = password_secret
        self._npm_password_secret_key = password_secret_key
        self._npm_login_path = self._prepare_login_script(publisher_path)
        self._node_js_version = node_js_version

    def publish(self, package_path):
        with Node(self._node_js_version):
            npm_username = self._npm_username
            npm_password = self._npm_password_secret.data()[self._npm_password_secret_key]
            npm_email = '{}@yandex-team.ru'.format(npm_username)

            run_process(
                [self._npm_login_path, npm_username, npm_password, npm_email],
                'npm_login',
                cwd=package_path,
                check=False
            )
            run_process(
                ['npm', 'whoami', '--registry', 'http://npm.yandex-team.ru/'],
                'npm_whoami',
                cwd=package_path
            )
            run_process(
                ['npm', 'publish', '--registry', 'http://npm.yandex-team.ru/'],
                'npm_publish',
                cwd=package_path
            )

    def _prepare_login_script(self, publisher_path):
        npm_login_sh_path = str(publisher_path.joinpath('npm-login.sh'))
        copy_static('publisher/npm-login.sh', npm_login_sh_path)
        run_process(['chmod', 'a+x', npm_login_sh_path], 'chmod-npm-login')
        return npm_login_sh_path
