#!/usr/bin/env bash

# Копипаст
# # Копипаст копипаста (+ опция --no-pass-enc) в репу infratest (бестпрактика)
# # https://github.yandex-team.ru/search-interfaces/trendbox-ci/blob/9e97fd4306afbe4c46e88d79a140573d283505d3/.ci/npm-login.sh
# # Ниже говорится про legacy-способ, но похоже, что не-legacy (через токен) пока не реализован.
# #
# # Использование
# #   npm-login.sh [--no-pass-enc] <login> <pass> <email>
# #
# # # Копипаст: https://github.yandex-team.ru/search-interfaces/frontend/blob/428e09ff48f1e68d96abad023e290d4d373aed13/.config/trendbox/npm-legacy-auth#L1
# # # Скрипт для авторизации в npm.yandex-team.ru "устаревшим" способом (legacy — имя + пароль).
# # # Генерирует npmrc в домашней директории пользователя. Не перезаписывает существующий.
# # # Принимает параметры в том же порядке, что и `npm login`.
# # # См. FEI-12614.
# # #
# # # Использование:
# # #   $ npm-legacy-auth <name> <password> <email>

set -o nounset
set -o errexit
set -o pipefail

script="$(basename "$0")"
npmrc="${HOME}/.npmrc"
registry_hostname="npm.yandex-team.ru"
encode_pass=true

if [ "$1" == "--no-pass-enc" ]; then
    encode_pass=false
    shift
fi

if [[ -n "$1" ]]; then
  user_name=$1
else
  echo "${script}: user name is required"
  exit 1
fi

if [[ -n "$2" ]]; then
  user_pass=$2
else
  echo "${script}: user password is required"
  exit 2
fi

if [[ -n "$3" ]]; then
  user_email=$3
else
  echo "${script}: user email is required"
  exit 3
fi

echo "${script}: will set npm auth credentials for ${user_name} at ${registry_hostname} in ${npmrc}"

if [[ -f ${npmrc} ]]; then
  echo "${script}: error: ${npmrc} exists, exiting"
  exit 5
fi

if [ "$encode_pass" == true ]; then
    # `-n` — не добавлять перенос строки
    user_pass=$(echo -n "${user_pass}" | base64)
fi

cat > "${npmrc}" << EOF
//${registry_hostname}/:_password="${user_pass}"
//${registry_hostname}/:username=${user_name}
//${registry_hostname}/:email=${user_email}
//${registry_hostname}/:always-auth=false
EOF
