# -*- coding: utf-8 -*-

from . import recipes


class Recipe(object):
    @staticmethod
    def init(config, index):
        if not config['package']['name'] or not config['package']['version']:
            raise Exception('"package.name" and "package.version" are required for every recipe')

        return {
            'config': config,
            'data': {
                'meta': {'id': index},
                'store': {}
            },
            'external': {}
        }

    def __init__(self, task, state):
        self._task = task
        self._state = state

    @property
    def label(self):
        package_params = self._state['config']['package']
        return '{}#{}'.format(package_params['name'], package_params['version'])

    @property
    def raw(self):
        return self._state

    def get(self, key, default_value=None):
        return self._state['external'].get(key, default_value)

    def set(self, key, value):
        '''
        Value must be JSON-serializable to be compatible with sandbox task Context requirements
        '''
        self._state['external'][key] = value

    def get_builder(self):
        config = self._state['config']
        Builder = getattr(getattr(recipes, config['type']), 'builder')
        return Builder(config['package'], config.get('build'), self._task, self._state['data'])

    def get_composer(self):
        config = self._state['config']
        Composer = getattr(getattr(recipes, config['type']), 'composer')
        return Composer(config['package'], config.get('compose'), self._task)
