# -*- coding: utf-8 -*-

from sandbox.projects.common.build.YaMake2 import YaMake2

from ...base_builder import BaseBuilder


class BindingBuilder(BaseBuilder):
    """
    Сборка node bindings под различные платформы.
    """

    def __init__(self, *args):
        super(BindingBuilder, self).__init__(*args)
        self._bindings_build_params = map(self._prepare_binding_build_params, self._build_params['platforms'])

    def _prepare_binding_build_params(self, binding_build_params):
        binding_build_params['params'] = dict(
            self._build_params.get('common_params', {}),
            **binding_build_params['params']
        )
        return binding_build_params

    def build(self):
        with self._memoize_stage('init_build_tasks'):
            return self._memoize_tasks('build_tasks', self._create_build_tasks())

        artifacts = self._get_artifacts(self._restore_task_ids('build_tasks'))

        self._done(artifacts)

    def _create_build_tasks(self):
        return map(self._create_build_task, self._bindings_build_params)

    def _create_build_task(self, binding_build_params):
        if 'platform' not in binding_build_params:
            raise Exception('`platform` is required param. Got {}'.format(binding_build_params))

        description = '{} ({})'.format(self._package_params['name'], binding_build_params['platform'])
        params = dict(binding_build_params['params'], description=description)

        return YaMake2(self._task, **params).enqueue()

    def _get_artifacts(self, task_ids):
        return map(self._get_artifacts_by_task_entry, enumerate(task_ids))

    def _get_artifacts_by_task_entry(self, entry):
        index, task_id = entry
        return self._get_artifact(task_id, self._bindings_build_params[index])

    def _get_artifact(self, task_id, binding_build_params):
        resource_type = binding_build_params['params'].get('result_rt') or 'ARCADIA_PROJECT'
        resource = self._get_task_resource_by_type(task_id, resource_type)
        if not resource:
            raise Exception('Resource not found for task {}'.format(task_id))

        meta = dict(binding_build_params)
        meta.pop('params')

        for attr_name, attr_value in meta.items():
            setattr(resource, attr_name, str(attr_value))

        return {'meta': meta, 'resource': resource}
