# -*- coding: utf-8 -*-

from sandbox import sdk2

from ....base_composer import BaseComposer
from ....utils import rewrite_package_json, copy_static, run_process


class BindingComposer(BaseComposer):
    """
    Композиция аддонов для динамического резолва в зависимости от платформы с оформлением в виде npm-пакета.
    """

    def compose(self, artifacts):
        path = self._get_path()

        self._create_binding_files(path, artifacts)
        self._create_resource_id_files(path, artifacts)
        self._create_proxy_url_files(path, artifacts)

        index_js_path = str(path.joinpath('index.js'))
        package_json_path = str(path.joinpath('package.json'))
        readme_md_path = str(path.joinpath('README.md'))

        copy_static('recipes/binding/composer/static/index.js', index_js_path)
        copy_static('recipes/binding/composer/static/package.json', package_json_path)
        copy_static('recipes/binding/composer/static/README.md', readme_md_path)

        rewrite_package_json(package_json_path, self._package_params)

        return str(path)

    def _create_binding_files(self, path, artifacts):
        for artifact in artifacts:
            binding_path = str(path.joinpath('binding-x64-{}.node'.format(artifact['meta']['platform'])))
            resource_path = str(sdk2.ResourceData(artifact['resource']).path)
            run_process(['cp', resource_path, binding_path])

    def _create_resource_id_files(self, path, artifacts):
        for artifact in artifacts:
            file_path = str(path.joinpath('{}-resource-id'.format(artifact['meta']['platform'])))
            with open(file_path, 'w') as f:
                f.write('{}\n'.format(artifact['resource'].id))

    def _create_proxy_url_files(self, path, artifacts):
        for artifact in artifacts:
            file_path = str(path.joinpath('{}-proxy-url'.format(artifact['meta']['platform'])))
            with open(file_path, 'w') as f:
                f.write('{}\n'.format(artifact['resource'].http_proxy))
