# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.common.build.YaMake2 import YaMake2

from ...base_builder import BaseBuilder


class PackageBuilder(BaseBuilder):
    """
    Сборка модуля через YA_MAKE, результатом которой является уже готовый к публикации пакет.
    """

    def build(self):
        with self._memoize_stage('init_build_task'):
            return self._memoize_task('build_task', self._create_build_task())

        path = self._get_package_path(self._restore_task_id('build_task'))

        self._done(path)

    def _create_build_task(self):
        params = dict(self._build_params, description=self._package_params['name'])
        return YaMake2(self._task, **params).enqueue()

    def _get_package_path(self, task_id):
        resource_type = self._build_params.get('result_rt') or 'ARCADIA_PROJECT'
        resource = self._get_task_resource(task_id, resource_type)
        if not resource:
            raise Exception('Resource of type "{}" not found for task #{}'.format(resource_type, task_id))

        return sdk2.ResourceData(resource).path
