# -*- coding: utf-8 -*-

from ...base_composer import BaseComposer
from ...utils import rewrite_package_json, run_process


class PackageComposer(BaseComposer):
    """
    Подготовка собранного пакета к публикации.
    """

    def compose(self, resource_path):
        in_resource_path = self._compose_params['in_resource_path']
        resource_path = resource_path.joinpath(in_resource_path) if in_resource_path is not None else resource_path

        package_json_path = str(resource_path.joinpath('package.json'))
        run_process(['chmod', 'a+w', str(package_json_path)])
        rewrite_package_json(package_json_path, self._package_params)

        return str(resource_path)
