# -*- coding: utf-8 -*-

import json
import collections

from sandbox import sdk2
from sandbox.sdk2.helpers.process import subprocess as sp


def rewrite_package_json(path, fields):
    with open(path, 'r') as src:
        # `object_pairs_hook` is to preserve original keys order of the `src`
        package_json = json.load(src, object_pairs_hook=collections.OrderedDict)

        _set_plain_fields(package_json, fields)
        _set_keywords(package_json, fields.get('keywords'))

        with open(path, 'w') as dst:
            json.dump(package_json, dst, indent=4)


def _set_plain_fields(package_json, fields):
    for field in ['name', 'version', 'description']:
        if isinstance(fields.get(field), basestring):
            package_json[field] = fields[field]


def _set_keywords(package_json, new_keywords):
    default_keywords = ['npmify']
    package_keywords = package_json.get('keywords') if isinstance(package_json.get('keywords'), list) else []
    new_keywords = new_keywords if isinstance(new_keywords, list) else []
    package_keywords.extend(new_keywords)
    package_keywords.extend(default_keywords)


def copy_static(static_id, destination_path):
    static_file = load_static(static_id)
    with open(destination_path, 'w') as f:
        f.write(static_file)


def load_static(static_id):
    from library.python import resource
    return resource.find(static_id)


def run_process(cmd, log_name=None, cwd=None, check=True):
    with sdk2.helpers.ProcessLog(logger=log_name or cmd[0]) as pl:
        return_code = sp.Popen(cmd, stdout=pl.stdout, stderr=pl.stderr, cwd=cwd).wait()
        if check and return_code != 0:
            raise sp.CalledProcessError(return_code, cmd)


def flatten(iterables):
    result = []
    for iterable in iterables:
        try:  # EAFP, sorry
            for i in iterable:
                if i:
                    result.append(i)
        except Exception:
            if iterable:
                result.append(iterable)

    return result
