# -*- coding: utf-8 -*-

import logging
import os
import tarfile

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.common.types import misc as ctm
from sandbox.sandboxsdk import process

from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.common import constants
from sandbox.projects.common.infra.YaMakeDAAS import YaMakeDAAS
from sandbox.projects.sandbox_ci import parameters
from sandbox.projects.sandbox_ci.task.binary_task import TasksResourceRequirement
from sandbox.projects.sandbox_ci.utils.context import Node


class SiInfraDocsPublish(TasksResourceRequirement, YaMakeDAAS):
    """
        Задача для публикации документации из аркадии с предварительным вызовом pre_build.py из корня таргета с документацией
    """

    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.DNS64

    class Parameters(YaMakeDAAS.Parameters):
        build_system = build_parameters.BuildSystem(default_value=constants.YMAKE_BUILD_SYSTEM)

    def on_create(self):
        pass

    def pre_build(self, source_dir):
        for target in self.get_targets():
            abs_target = os.path.join(source_dir, target)
            script = os.path.join(abs_target, 'pre_build.py')
            if os.path.exists(script):
                log_prefix = 'pre_build_{}'.format(target.replace('/', '__'))
                process.run_process(['python', script], work_dir=abs_target, log_prefix=log_prefix, check=True)
