# -*- coding: utf-8 -*-
import os
import shutil

from sandbox import sdk2
from sandbox import common
from sandbox.common.types import resource
from sandbox.common.errors import ResourceNotFound
from sandbox.projects.repo.convert import VcsApply

from sandbox.sandboxsdk.environments import SandboxEnvironment


class ArcApplyToolEnvironment(SandboxEnvironment):
    """
        Arc apply tool
    """
    resource_type = 'VCS_APPLY'
    resource_attrs = dict()
    name = 'arc_apply'
    sys_path_utils = ['arc_apply', ]
    use_cache = True

    def __init__(self, version=None, platform=None, attrs=None):
        super(ArcApplyToolEnvironment, self).__init__(version, platform)

        if attrs:
            self.resource_attrs.update(**attrs)

    @property
    def compatible_resource(self):
        sysparams = common.utils.get_sysparams()

        params = dict(
            resource_type=VcsApply,
            state=resource.State.READY,
            attrs=dict(
                platform=sysparams.get('arch'),
                released='stable',
                **self.resource_attrs
            ),
        )

        self.logger.debug('Searching resource by params: {}'.format(params))

        res = sdk2.Resource.find(**params).order(-sdk2.Resource.id).first()

        if res is None:
            raise ResourceNotFound('Could not find any VCS_APPLY resource')

        self.logger.debug('Found arc apply tool res %s', res)
        self.resource_id = res.id

        return res

    def get_env_dir(self):
        resource_path = self.get_environment_resource()

        # apply - very common name, better specify
        env_dir = self.get_environment_folder()
        binary = os.path.join(env_dir, self.name)
        lock_file = os.path.join(os.path.dirname(env_dir), os.path.basename(env_dir) + '.lock')

        with common.utils.RFLock(lock_file):
            if os.path.exists(env_dir):
                return env_dir

            self.touch()
            shutil.copy(resource_path, binary)
            self.meta.store()

        return env_dir

    def prepare(self):
        env_dir = self.get_env_dir()
        self.update_os_path_env(env_dir)
        self.check_environment()

        return env_dir
