# -*- coding: utf-8 -*-

import os
import logging

from contextlib import nested

from sandbox.projects.common.vcs.arc import Arc
from sandbox.projects.sandbox_ci.managers.arc.arc_apply import ArcApplyToolEnvironment


def create_arc_context(mount_point, store_path, commit=None, object_store_path=None, extra_params=[], arc_apply_attrs=None):
    # Костыль, необходимый, чтобы под Ubuntu Bionic не происходила ошибка DNS resolution failed при работе с arc.
    # Необходимо оторвать после FEI-19292.
    if os.environ.get('GRPC_DNS_RESOLVER', None) is None:
        os.environ.update({
            'GRPC_DNS_RESOLVER': 'native'
        })

    ArcApplyToolEnvironment(attrs=arc_apply_attrs).prepare()

    logging.debug('Mounting Arc')
    mount_point.mkdir(parents=True, exist_ok=True)
    store_path.mkdir(parents=True, exist_ok=True)

    mount_params = dict(
        path=None,
        changeset=commit,
        mount_point=str(mount_point),
        store_path=str(store_path),
        object_store_path=object_store_path,
        allow_root=True,
        extra_params=extra_params,
        fetch_all=False,
    )

    logging.debug('Arc mount parameters: {}'.format(mount_params))
    context = nested(Arc().mount_path(**mount_params))

    return context
