# -*- coding: utf-8 -*-

import logging
import os
import traceback


class AssertMetricsManager(object):
    def __init__(self, task):
        self.task = task

    def send_coverage_to_statface(self):
        if not self.task.config.is_enabled('tests', 'hermione_send_metrics_coverage'):
            logging.warn('skip send assert metrics statistic to upload.stat.yandex-team.ru')
            return

        # catch statface errors, see https://st.yandex-team.ru/FEI-5011
        import socket
        from statface_client import StatfaceClientError
        from requests.exceptions import HTTPError, ConnectionError
        try:
            report_path = 'Yandex.Productivity/infratest/{}/{}/assert-metrics'.format(
                self.task.project_name, self.task.Parameters.project_build_context
            )
            data_path = os.path.join(self.task.project_name, os.environ['html_reporter_path'], 'metrics-coverage.tsv')
            report = self.task.statface.get_report(report_path)
            if not os.path.isfile(data_path):
                logging.warn('Metrics coverage file {} not found'.format(data_path))
                return

            # there is '\n' in the end of each line which causes Unknown format Error so strip is needed
            data = list(map(lambda line: line.strip(), open(data_path).readlines()))
            report.upload_data(scale=u'd', format=u'tsv', data=data)

        except (StatfaceClientError, HTTPError, ConnectionError, socket.error):
            logging.exception('Failed to upload metrics coverage data to Stat')
            error_traceback = traceback.format_exc()
            self.task.Context.noncritical_errors.append(error_traceback)
