# -*- coding: utf-8 -*-

from sandbox.common.utils import singleton_property

from sandbox.projects.sandbox_ci.managers.profiled_action_creator import ProfiledActionCreator
from sandbox.projects.sandbox_ci.managers.profiler import ProfilerManager
from sandbox.projects.sandbox_ci.managers.profiler import get_history_tracker


class DeepActionsProfiler(ProfilerManager):
    def __init__(self, task):
        """
        :param task: Task instance.
        :type task: sandbox.projects.sandbox_ci.task.BaseTask
        """
        self.task = task
        self._history_tracker = get_history_tracker(task)

        if not task.Context.task_steps:
            task.Context.task_steps = []

    @singleton_property
    def actions(self):
        return ProfiledActionCreator(self.task, DeepActionsProfiler)

    @classmethod
    def _get_task_actions(cls, task):
        return task.Context.task_steps

    @classmethod
    def register_task_step(cls, task, action_tag, description, duration, start=None, finish=None):
        if start is None:
            return

        super(DeepActionsProfiler, cls).register_task_step(task, action_tag, description, duration, start, finish)

    def register_all_actions(self):
        for status in set(self._history_tracker.get_task_statuses()):
            self._register_task_action(status)

    def _register_task_action(self, status):
        times = self._history_tracker.get_time_intervals(status)

        for start_time, finish_time in times:
            self.register_action(
                status,
                description='',
                duration=(finish_time - start_time).seconds,
                start=start_time,
                finish=finish_time,
            )
