import logging

from sandbox.projects.sandbox_ci.utils.request import send_request

METRICS_LOGGER_BASE_URL = 'https://webhook-handler.si.yandex-team.ru/v1/metrics-logger'


class MetricsLogger(object):
    def _send(self, type, value):
        """
        Sends data to metrics logger.

        :param type: Metric type
        :type type: str
        :param value: Metric value
        :type value: dict | list of dict
        """
        logging.debug('Sending data to metrics logger: type={}, value={}'.format(type, value))

        return send_request(
            method='post',
            url=METRICS_LOGGER_BASE_URL,
            headers={
                'Content-Type': 'application/json',
            },
            json={
                'type': type,
                'value': value,
            },
            timeout=60,
        )

    def log_release_steps(self, steps):
        """
        Sends data to release-steps metric.

        :param steps: Release step(s) dict.
        :type steps: dict | list of dict
        """
        self._send('release-steps', steps)
