# -*- coding: utf-8 -*-

import datetime as dt
from sandbox.sdk2.helpers.misc import ProgressMeter


class ProfiledActionCreator(object):
    def __init__(self, task, manager):
        self.__task = task
        self.__manager = manager

    def __getattr__(self, name):
        return ProfiledActionContext(self.__task, name, self.__manager)

    def __getitem__(self, name):
        return ProfiledActionContext(self.__task, name, self.__manager)


class ProfiledActionContext(ProgressMeter):
    def __init__(self, task, action_tag, manager):
        self.__action_tag = action_tag
        self.__manager = manager
        self.task = task

        super(ProfiledActionContext, self).__init__(action_tag)

    def __call__(self, description=None):
        if description:
            self.description = description

        return self

    def __enter__(self):
        action_context = super(ProfiledActionContext, self).__enter__()
        self.start_dt = dt.datetime.utcnow()
        return action_context

    def __exit__(self, *args, **kwargs):
        self.finish_dt = dt.datetime.utcnow()
        duration = self.finish_dt - self.start_dt

        self.__manager.register_task_step(
            self.task,
            self.__action_tag,
            self.description,
            duration.seconds,
            start=self.start_dt,
            finish=self.finish_dt,
        )

        super(ProfiledActionContext, self).__exit__(*args, **kwargs)
